/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.text.Collator;
import java.util.Locale;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.PriorityQueue;

class FieldDocSortedHitQueue
extends PriorityQueue {
    volatile SortField[] fields;
    volatile Collator[] collators;

    FieldDocSortedHitQueue(SortField[] fields, int size) throws IOException {
        this.fields = fields;
        this.collators = this.hasCollators(fields);
        this.initialize(size);
    }

    synchronized void setFields(SortField[] fields) {
        if (this.fields == null) {
            this.fields = fields;
            this.collators = this.hasCollators(fields);
        }
    }

    SortField[] getFields() {
        return this.fields;
    }

    private Collator[] hasCollators(SortField[] fields) {
        if (fields == null) {
            return null;
        }
        Collator[] ret = new Collator[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Locale locale = fields[i].getLocale();
            if (locale == null) continue;
            ret[i] = Collator.getInstance(locale);
        }
        return ret;
    }

    protected final boolean lessThan(Object a, Object b) {
        FieldDoc docA = (FieldDoc)a;
        FieldDoc docB = (FieldDoc)b;
        int n = this.fields.length;
        int c = 0;
        block16: for (int i = 0; i < n && c == 0; ++i) {
            float f2;
            float f1;
            String s2;
            String s1;
            int i2;
            int i1;
            float r2;
            float r1;
            int type = this.fields[i].getType();
            if (this.fields[i].getReverse()) {
                switch (type) {
                    case 0: {
                        r1 = ((Float)docA.fields[i]).floatValue();
                        r2 = ((Float)docB.fields[i]).floatValue();
                        if (r1 < r2) {
                            c = -1;
                        }
                        if (!(r1 > r2)) continue block16;
                        c = 1;
                        continue block16;
                    }
                    case 1: 
                    case 4: {
                        i1 = (Integer)docA.fields[i];
                        i2 = (Integer)docB.fields[i];
                        if (i1 > i2) {
                            c = -1;
                        }
                        if (i1 >= i2) continue block16;
                        c = 1;
                        continue block16;
                    }
                    case 3: {
                        s1 = (String)((Object)docA.fields[i]);
                        s2 = (String)((Object)docB.fields[i]);
                        if (s2 == null) {
                            c = -1;
                            continue block16;
                        }
                        if (s1 == null) {
                            c = 1;
                            continue block16;
                        }
                        if (this.fields[i].getLocale() == null) {
                            c = s2.compareTo(s1);
                            continue block16;
                        }
                        c = this.collators[i].compare(s2, s1);
                        continue block16;
                    }
                    case 5: {
                        f1 = ((Float)docA.fields[i]).floatValue();
                        f2 = ((Float)docB.fields[i]).floatValue();
                        if (f1 > f2) {
                            c = -1;
                        }
                        if (!(f1 < f2)) continue block16;
                        c = 1;
                        continue block16;
                    }
                    case 9: {
                        c = docB.fields[i].compareTo(docA.fields[i]);
                        continue block16;
                    }
                    case 2: {
                        throw new RuntimeException("FieldDocSortedHitQueue cannot use an AUTO SortField");
                    }
                    default: {
                        throw new RuntimeException("invalid SortField type: " + type);
                    }
                }
            }
            switch (type) {
                case 0: {
                    r1 = ((Float)docA.fields[i]).floatValue();
                    r2 = ((Float)docB.fields[i]).floatValue();
                    if (r1 > r2) {
                        c = -1;
                    }
                    if (!(r1 < r2)) continue block16;
                    c = 1;
                    continue block16;
                }
                case 1: 
                case 4: {
                    i1 = (Integer)docA.fields[i];
                    i2 = (Integer)docB.fields[i];
                    if (i1 < i2) {
                        c = -1;
                    }
                    if (i1 <= i2) continue block16;
                    c = 1;
                    continue block16;
                }
                case 3: {
                    s1 = (String)((Object)docA.fields[i]);
                    s2 = (String)((Object)docB.fields[i]);
                    if (s1 == null) {
                        c = -1;
                        continue block16;
                    }
                    if (s2 == null) {
                        c = 1;
                        continue block16;
                    }
                    if (this.fields[i].getLocale() == null) {
                        c = s1.compareTo(s2);
                        continue block16;
                    }
                    c = this.collators[i].compare(s1, s2);
                    continue block16;
                }
                case 5: {
                    f1 = ((Float)docA.fields[i]).floatValue();
                    f2 = ((Float)docB.fields[i]).floatValue();
                    if (f1 < f2) {
                        c = -1;
                    }
                    if (!(f1 > f2)) continue block16;
                    c = 1;
                    continue block16;
                }
                case 9: {
                    c = docA.fields[i].compareTo(docB.fields[i]);
                    continue block16;
                }
                case 2: {
                    throw new RuntimeException("FieldDocSortedHitQueue cannot use an AUTO SortField");
                }
                default: {
                    throw new RuntimeException("invalid SortField type: " + type);
                }
            }
        }
        return c > 0;
    }
}

