/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: EDataGraph.java,v 1.6 2007/06/12 15:06:34 emerks Exp $
 */
package org.eclipse.emf.ecore.sdo;

import java.io.Serializable;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

import commonj.sdo.DataGraph;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>EData Graph</b></em>'.
 * @extends Serializable
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.emf.ecore.sdo.EDataGraph#getResourceSet <em>Resource Set</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.EDataGraph#getRootResource <em>Root Resource</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.EDataGraph#getEChangeSummary <em>EChange Summary</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.EDataGraph#getERootObject <em>ERoot Object</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.emf.ecore.sdo.SDOPackage#getEDataGraph()
 * @model superTypes="org.eclipse.emf.ecore.sdo.DataGraph"
 * @generated
 */
public interface EDataGraph extends EObject, DataGraph, Serializable {
  /**
   * Returns the value of the '<em><b>Resource Set</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Resource Set</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Resource Set</em>' attribute.
   * @see #setResourceSet(ResourceSet)
   * @see org.eclipse.emf.ecore.sdo.SDOPackage#getEDataGraph_ResourceSet()
   * @model transient="true"
   * @generated
   */
  ResourceSet getResourceSet();

  /**
   * Sets the value of the '{@link org.eclipse.emf.ecore.sdo.EDataGraph#getResourceSet <em>Resource Set</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Resource Set</em>' attribute.
   * @see #getResourceSet()
   * @generated
   */
  void setResourceSet(ResourceSet value);

  /**
   * Returns the value of the '<em><b>Root Resource</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Root Resource</em>' attribute isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Root Resource</em>' attribute.
   * @see org.eclipse.emf.ecore.sdo.SDOPackage#getEDataGraph_RootResource()
   * @model transient="true" changeable="false" volatile="true"
   * @generated
   */
  Resource getRootResource();

  /**
   * Returns the resource of this data graph; one is created if necessary.
   * @return the resource of this data graph.
   */
  Resource getDataGraphResource();

  /**
   * Returns the value of the '<em><b>EChange Summary</b></em>' reference.
   * It is bidirectional and its opposite is '{@link org.eclipse.emf.ecore.sdo.EChangeSummary#getEDataGraph <em>EData Graph</em>}'.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>EChange Summary</em>' reference isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>EChange Summary</em>' reference.
   * @see #setEChangeSummary(EChangeSummary)
   * @see org.eclipse.emf.ecore.sdo.SDOPackage#getEDataGraph_EChangeSummary()
   * @see org.eclipse.emf.ecore.sdo.EChangeSummary#getEDataGraph
   * @model opposite="eDataGraph" resolveProxies="false" required="true"
   * @generated
   */
  EChangeSummary getEChangeSummary();

  /**
   * Sets the value of the '{@link org.eclipse.emf.ecore.sdo.EDataGraph#getEChangeSummary <em>EChange Summary</em>}' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>EChange Summary</em>' reference.
   * @see #getEChangeSummary()
   * @generated
   */
  void setEChangeSummary(EChangeSummary value);

  /**
   * Returns the value of the '<em><b>ERoot Object</b></em>' reference.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>ERoot Object</em>' reference isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>ERoot Object</em>' reference.
   * @see #setERootObject(EObject)
   * @see org.eclipse.emf.ecore.sdo.SDOPackage#getEDataGraph_ERootObject()
   * @model resolveProxies="false" required="true"
   * @generated
   */
  EObject getERootObject();

  /**
   * Sets the value of the '{@link org.eclipse.emf.ecore.sdo.EDataGraph#getERootObject <em>ERoot Object</em>}' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>ERoot Object</em>' reference.
   * @see #getERootObject()
   * @generated
   */
  void setERootObject(EObject value);

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @model
   * @generated
   */
  EClassifier getEClassifier(String namespaceURI, String typeName);

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @model
   * @generated
   */
  EObject createEObject(EClass type);

  /**
   * An internal interface implemented by all data graphs to support.
   */
  interface Internal
  {
    /**
     * Returns an object to be used as a write replacement.
     * @return an object to be used as a write replacement.
     */
    Object getWriteReplacement();

    /**
     * Returns an object to be used as a write replacement for the given object in the data graph..
     * @param eObject the object in question.
     * @return an object to be used as a write replacement.
     */
    Object getWriteReplacement(EObject eObject);
  }
} // EDataGraph
