package services.account;

import java.util.List;

import org.apache.tuscany.core.sdo.util.DataFactory;
import services.accountdata.AccountDataService;
import services.accountdata.CheckingAccount;
import services.accountdata.SavingsAccount;
import services.accountdata.StockAccount;
import services.stockquote.StockQuoteService;
import org.apache.tuscany.core.runtime.Runtime;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;

public class AccountServiceImpl implements AccountService {

	public DataFactory dataFactory;
	
	@Property
	public String currency = "USD";

	@Reference
	public AccountDataService accountDataService;
	@Reference
	public StockQuoteService stockQuoteService;
	
	public AccountServiceImpl() {
		dataFactory = Runtime.INSTANCE.getModuleContext().
			getSDOHelperProvider().getDataFactory();
	}
	
	public AccountReport getAccountReport(String customerID) {
		
		AccountReport accountReport = (AccountReport)dataFactory.create(AccountReport.class);
		List accountSummaries = accountReport.getAccountSummaries();
		
		CheckingAccount checkingAccount = accountDataService.getCheckingAccount(customerID);
		AccountSummary checkingAccountSummary = (AccountSummary)dataFactory.create(AccountSummary.class);
		checkingAccountSummary.setAccountNumber(checkingAccount.getAccountNumber());
		checkingAccountSummary.setAccountType("checking");
		checkingAccountSummary.setBalance(fromUSDollarToCurrency(checkingAccount.getBalance()));
		accountSummaries.add(checkingAccountSummary);

		SavingsAccount savingsAccount = accountDataService.getSavingsAccount(customerID);
		AccountSummary savingsAccountSummary = (AccountSummary)dataFactory.create(AccountSummary.class);
		savingsAccountSummary.setAccountNumber(savingsAccount.getAccountNumber());
		savingsAccountSummary.setAccountType("savings");
		savingsAccountSummary.setBalance(fromUSDollarToCurrency(savingsAccount.getBalance()));
		accountSummaries.add(savingsAccountSummary);		
		
		StockAccount stockAccount = accountDataService.getStockAccount(customerID);	
		AccountSummary stockAccountSummary = (AccountSummary)dataFactory.create(AccountSummary.class);
		stockAccountSummary.setAccountNumber(stockAccount.getAccountNumber());
		stockAccountSummary.setAccountType("stock");
		float balance = (stockQuoteService.getQuote(stockAccount.getSymbol())) * stockAccount.getQuantity();
		stockAccountSummary.setBalance(fromUSDollarToCurrency(balance));	
		accountSummaries.add(stockAccountSummary);	
		
		return accountReport;
	}
	
	private float fromUSDollarToCurrency(float value){
		
		if (currency.equals("USD")) return value; else
		if (currency.equals("EURO")) return value * 0.8f; else
		return 0.0f;
	}
}
