/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.publicapi.example;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import org.eclipse.stp.b2j.core.publicapi.engine.BPELEngineListener;
import org.eclipse.stp.b2j.core.publicapi.engine.IndependantBPELEngine;
import org.eclipse.stp.b2j.core.publicapi.program.BPELProgram;
import org.eclipse.stp.b2j.core.publicapi.program.IndependantBPELProgram;

public class RuntimeOnlyCompileExample {
    private static void usage() {
        System.out.println("Usage: RuntimeOnlyCompileExample <file>");
        System.out.println("");
        System.out.println("e.g. RuntimeOnlyCompileExample mytest.bpel  (requires full JAR)");
        System.out.println("     RuntimeOnlyExecuteExample mytest.bpel.b2jprog  (requires runtime only JAR)");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            RuntimeOnlyCompileExample.usage();
        }
        String file = args[0];
        BPELProgram program = new IndependantBPELProgram(new File(file));
        IndependantBPELEngine engine = new IndependantBPELEngine(program);
        program = engine.compileProgram(new PrintoutEngineListener());
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(String.valueOf(file) + ".b2jprog"));
        out.writeObject(program);
        out.close();
        System.out.println("\nProgram compilation OK");
        System.out.println("Wrote: " + file + ".b2jprog");
    }

    private static class PrintoutEngineListener
    implements BPELEngineListener {
        private PrintoutEngineListener() {
        }

        public void printInfo(String s) {
            System.out.println("INFO: " + s);
        }

        public void printDebug(String s) {
            System.out.println("DEBUG: " + s);
        }

        public void printEngineInfo(String s) {
            System.out.println("ENGINE_INFO: " + s);
        }

        public void printEngineDebug(String s) {
            System.out.println("ENGINE_DEBUG: " + s);
        }
    }
}

