/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.publicapi.program;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.publicapi.program.BPELProgram;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class IndependantBPELProgram
implements BPELProgram {
    File bpel_file;
    String name;
    String base_uri;
    SessionAddress coordinator_daemon;
    SessionAddress coordinator;
    ArrayList worker_daemons = new ArrayList();
    ArrayList workers = new ArrayList();
    ArrayList jar_dependencies = new ArrayList();
    HashMap compiled_data = new HashMap();

    public IndependantBPELProgram(File file) throws IOException {
        this.bpel_file = file;
        this.name = file.getName();
        this.base_uri = this.bpel_file.getAbsoluteFile().getParentFile().toURL().toString();
    }

    public String getName() {
        return this.name;
    }

    public String getBaseURI() {
        return this.base_uri;
    }

    public String getBpelSource() throws Exception {
        FileInputStream fin = new FileInputStream(this.bpel_file);
        String dat = StreamUtils.readAllAsString(new BufferedInputStream(fin));
        fin.close();
        return dat;
    }

    public SessionAddress[] getWorkerDaemons() {
        SessionAddress[] tmp = new SessionAddress[this.worker_daemons.size()];
        this.worker_daemons.toArray(tmp);
        return tmp;
    }

    public SessionAddress[] getWorkerHosts() {
        SessionAddress[] tmp = new SessionAddress[this.workers.size()];
        this.worker_daemons.toArray(tmp);
        return tmp;
    }

    public SessionAddress getCoordinatorHost() {
        return this.coordinator;
    }

    public SessionAddress getCoordinatorDaemon() {
        return this.coordinator_daemon;
    }

    public String[] getProgramDependencies() {
        String[] deps = new String[this.jar_dependencies.size()];
        this.jar_dependencies.toArray(deps);
        return deps;
    }

    public void setCoordinatorHost(SessionAddress daemon_address, SessionAddress coordinator_address) {
        this.coordinator_daemon = daemon_address;
        this.coordinator = coordinator_address;
    }

    public void addWorkerHost(SessionAddress daemon_address, SessionAddress worker_address) {
        this.worker_daemons.add(daemon_address);
        this.workers.add(worker_address);
    }

    public void addJarDependency(String localJarPath) {
        this.jar_dependencies.add(localJarPath);
    }

    public void setCompiledData(String key, Object o) {
        this.compiled_data.put(key, o);
    }

    public Object getCompiledData(String key) {
        return this.compiled_data.get(key);
    }
}

