/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;


/**
 * @author rcernich
 *
 * Created on Apr 8, 2004
 */
public interface ITechnologyMap {
	
	ISupportedTechnologyType[] getSupportedTechnologyTypes();
	
	/**
	 * Returns the type of server that the packages produced by this extension
	 * may be deployed to.
	 * 
	 * @return the supported server type
	 */
	IServerDefinition getServerDefinition();
	
	/**
	 * Returns the server version these technologies are supported by.
	 * 
	 * @return the server version.
	 */
	IVersion getServerVersion();
	
	/**
	 * Returns the match rule that should be used to determine whether or not
	 * this technology map may be used for a server whose version is greater
	 * than the server version the map is specified for.
	 * 
	 * @return the match rule to use when verifying compatibility with a target
	 * server.
	 */
	MatchRule getVersionMatchRule();
	
	/**
	 * Returns the type of runtime that the packages produced by this extension
	 * may be deployed to.
	 * 
	 * @return the supported runtime type
	 */
	IRuntimeDefinition getRuntimeDefinition();
	
	/**
	 * Returns the runtime version these technologies are supported by.
	 * 
	 * @return the runtime version.
	 */
	IVersion getRuntimeVersion();
	
}
