/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.ui.actions;

import java.util.Iterator;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ExecuteDeployActionDelegate implements IObjectActionDelegate {

	IStructuredSelection mSelection;
	IWorkbenchPart mPart;

	/**
	 * Constructor for Action1.
	 */
	public ExecuteDeployActionDelegate() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		mPart = targetPart;
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		for (Iterator it = mSelection.iterator(); it.hasNext();) {
			Object obj = it.next();
			IResource res;
			if (obj instanceof IResource) {
				res = (IResource) obj;
			}
			else if (obj instanceof IAdaptable) {
				res = (IResource) ((IAdaptable) obj)
						.getAdapter(IResource.class);
			}
			else {
				res = (IResource) Platform.getAdapterManager().getAdapter(obj,
						IResource.class);
			}
			if (res != null && res.getType() == IResource.FILE) {
				ResourceSet rs = new ResourceSetImpl();
				Resource r = rs.getResource(URI.createPlatformResourceURI(res
						.getFullPath().toString()), true);
				if (r.getContents().size() > 0
						&& r.getContents().get(0) instanceof Root) {
					Root root = (Root) r.getContents().get(0);
					ExecuteDeployAction deployAction = new ExecuteDeployAction(
							new String(), mPart.getSite().getShell());
					deployAction
							.selectionChanged(new StructuredSelection(root));
					deployAction.run();
				}
				else {
					System.err
							.println("Selected resource is not a deployment file (" //$NON-NLS-1$
									+ res + ")"); //$NON-NLS-1$
				}
			}
			else {
				System.err.println("Selected resource is not a file (" + res //$NON-NLS-1$
						+ ")"); //$NON-NLS-1$
			}
		}
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			mSelection = (IStructuredSelection) selection;
		}
		else {
			mSelection = StructuredSelection.EMPTY;
		}
	}

}