/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module;

/**
 * 
 * Module delegate for service component
 * 
 * @author jma
 */
import java.io.File;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.soas.deploy.core.FilePackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ProjectModule;

public class ServiceModuleDelegate extends ProjectModule implements IWebModule{
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(ServiceModuleDelegate.class);
	
	IPath ROOT = new Path("/"); //$NON-NLS-1$ 
	
	FilePackageOutputDescriptor fileDesc;
	
	IModule module;

	/**
	 * create service module delegate from project and packageDescriptor
	 * @param project, the project which contains the module
	 * @param desc, the package descriptor
	 * @see IPackageOutputDescriptor
	 */
	public ServiceModuleDelegate(IProject project, IPackageOutputDescriptor desc) {
		super(project);
		fileDesc = (FilePackageOutputDescriptor)desc;		
	}
	
	@Override
	public IModule[] getChildModules() {
		//we don't have any child module yet.
		//for sca module, the service may consistent with small components
		return null;
	}

	@Override
	public IModuleResource[] members() throws CoreException {
		File file = fileDesc.getFile();
		String moduleName = file.getName();
        ModuleFile mFile = new ModuleFile(file,
        		moduleName,
        		ROOT.makeRelative());
		return new IModuleResource[] {mFile};
	}

	@Override
	public IStatus validate() {
		//just return ok for now. will revisit to check the package later
		return Status.OK_STATUS;
	}

 	public String getContextRoot() {
 		String context = fileDesc.getFile().getName();
 		if (context.lastIndexOf(".") > 0) {
 			context = context.substring(0, context.lastIndexOf("."));
 		}
 		LOG.debug("getContextRoot return:" + context);
 		return context;
	}

 	public void setModule(IModule mod) {
 		module = mod;
 	}
 	
	public IModule[] getModules() {
		return new IModule[]{module};
	}

	public String getURI(IModule module) {
		LOG.debug("get url called for module:" + module);
		return fileDesc.getLogicalName();
	}

	public IContainer[] getJavaOutputFolders() {
		return null;
	}

	public IContainer[] getResourceFolders() {
		return null;
	}

	public boolean isBinary() {
		return true;
	}

}
