/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.sca.preferences;

import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.stp.sc.sca.ScScaPlugin;
import org.eclipse.stp.sc.sca.ScScaResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SCAMainPreferencePage extends FieldEditorPreferencePage
    implements IWorkbenchPreferencePage {
	
    private IPreferenceStore mStore;
    
    public SCAMainPreferencePage() {
        super(GRID);
        mStore = ScScaPlugin.getDefault().getPreferenceStore();
        setPreferenceStore(mStore);
    }

    @Override
    protected void adjustGridLayout() {
    	super.adjustGridLayout();
    }
    
   
    @Override
    protected void createFieldEditors() {
        createSpecGroup(getFieldEditorParent());
    }

    private void createSpecGroup(Composite parentContainer) {
        Group grpSpec = new Group(parentContainer, SWT.NONE);
        grpSpec.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.GRAB_HORIZONTAL));
        grpSpec.setLayout(new FillLayout());
        grpSpec.setText(ScScaResources.getString("pref.sca.grp.spec"));
        StringFieldEditor assembleSpecEditor = new StringFieldEditor(SCAPreferenceConstants.SPEC_ASSEMBLY_MODEL,
        		ScScaResources.getString("pref.sca.spec.assembly"),
        		grpSpec);
        assembleSpecEditor.setEnabled(false, grpSpec);
        addField(assembleSpecEditor);
        StringFieldEditor implSpecEditor = new StringFieldEditor(SCAPreferenceConstants.SPEC_IMPL_MODEL,
        		ScScaResources.getString("pref.sca.spec.impl"),
        		grpSpec);
        implSpecEditor.setEnabled(false, grpSpec);
        addField(implSpecEditor);
    }   

    public void init(IWorkbench workbench) {
    }
}
