/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.delete.operations;

import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;

public interface IDeleteRootSCAModelDataModelProperties extends
      IAbstractScribblerDataModelProperties {
   /**
    * [REQUIRED] SCAObject which needs to be deleted. This could be either a
    * Component/Export/Import or ReferenceSet that have their own Resource
    * associated to it.
    * 
    * Type = {@link com.ibm.wsspi.sca.scdl.Component} or
    * {@link com.ibm.wsspi.sca.scdl.Export} or
    * {@link com.ibm.wsspi.sca.scdl.Import} or
    * {@link com.ibm.wsspi.sca.scdl.ReferenceSet}
    */
   public static final String SCAOBJECT_TO_DELETE = "IDeleteRootSCAModelDataModelProperties.SCAOBJECT_TO_DELETE"; //$NON-NLS-1$
}
