/**
 * <copyright> </copyright>
 * 
 * $Id: ComponentTypeImpl.java,v 1.2 2006/04/05 14:26:12 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.internal.introspection.ISafeIntrospector;
import org.eclipse.stp.core.internal.introspection.SafeIntrospector;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.introspection.IComponentTypeIntrospector;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.Service;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Component Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.ComponentTypeImpl#getServices <em>Services</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ComponentTypeImpl#getReferences <em>References</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ComponentTypeImpl#getProperties <em>Properties</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ComponentTypeImpl#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ComponentTypeImpl#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ComponentTypeImpl extends SCAInternalObjectImpl implements
      ComponentType {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright                 = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getServices() <em>Services</em>}'
    * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getServices()
    * @generated
    * @ordered
    */
   protected EList            services                  = null;

   /**
    * The cached value of the '{@link #getReferences() <em>References</em>}'
    * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getReferences()
    * @generated
    * @ordered
    */
   protected EList            references                = null;

   /**
    * The cached value of the '{@link #getProperties() <em>Properties</em>}'
    * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getProperties()
    * @generated
    * @ordered
    */
   protected EList            properties                = null;

   /**
    * The cached value of the '{@link #getAny() <em>Any</em>}' attribute list.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAny()
    * @generated
    * @ordered
    */
   protected FeatureMap       any                       = null;

   /**
    * The cached value of the '{@link #getAnyAttribute() <em>Any Attribute</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAnyAttribute()
    * @generated
    * @ordered
    */
   protected FeatureMap       anyAttribute              = null;

   private boolean            hasIntrospectedServices   = false;

   private boolean            hasIntrospectedReferences = false;

   private boolean            hasIntrospectedProperties = false;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ComponentTypeImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getComponentType();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public List getServices() {
      if (!hasIntrospectedServices) {
         synchronized (this) {
            if (!hasIntrospectedServices) {
               ISafeIntrospector safeIntrospector = new SafeIntrospector() {
                  public void run() throws Exception {
                     IComponentTypeIntrospector introspector = findIntrospector();
                     if (introspector != null)
                        introspector.introspect(
                              SCAPackage.COMPONENT_TYPE__SERVICES,
                              getServicesGen());
                  }
               };
               eSetDeliver(false);
               Platform.run(safeIntrospector);
               eSetDeliver(true);
               hasIntrospectedServices = true;
            }
         }
      }
      return getServicesGen();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getServicesGen() {
      if (services == null) {
         services = new EObjectContainmentEList(Service.class, this,
               SCAPackage.COMPONENT_TYPE__SERVICES);
      }
      return services;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public List getReferences() {
      if (!hasIntrospectedReferences) {
         synchronized (this) {
            if (!hasIntrospectedReferences) {
               ISafeIntrospector safeIntrospector = new SafeIntrospector() {
                  public void run() throws Exception {
                     IComponentTypeIntrospector introspector = findIntrospector();
                     if (introspector != null)
                        introspector.introspect(
                              SCAPackage.COMPONENT_TYPE__REFERENCES,
                              getReferencesGen());
                  }
               };

               eSetDeliver(false);
               Platform.run(safeIntrospector);
               eSetDeliver(true);
               hasIntrospectedReferences = true;
            }
         }
      }
      return getReferencesGen();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getReferencesGen() {
      if (references == null) {
         references = new EObjectContainmentEList(Reference.class, this,
               SCAPackage.COMPONENT_TYPE__REFERENCES);
      }
      return references;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public List getProperties() {
      if (!hasIntrospectedProperties) {
         synchronized (this) {
            if (!hasIntrospectedProperties) {
               ISafeIntrospector safeIntrospector = new SafeIntrospector() {
                  public void run() throws Exception {
                     IComponentTypeIntrospector introspector = findIntrospector();
                     if (introspector != null)
                        introspector.introspect(
                              SCAPackage.COMPONENT_TYPE__PROPERTIES,
                              getPropertiesGen());
                  }
               };

               eSetDeliver(false);
               Platform.run(safeIntrospector);
               eSetDeliver(true);
               hasIntrospectedProperties = true;
            }
         }
      }
      return getPropertiesGen();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getPropertiesGen() {
      if (properties == null) {
         properties = new EObjectContainmentEList(Property.class, this,
               SCAPackage.COMPONENT_TYPE__PROPERTIES);
      }
      return properties;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAny() {
      if (any == null) {
         any = new BasicFeatureMap(this, SCAPackage.COMPONENT_TYPE__ANY);
      }
      return any;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAnyAttribute() {
      if (anyAttribute == null) {
         anyAttribute = new BasicFeatureMap(this,
               SCAPackage.COMPONENT_TYPE__ANY_ATTRIBUTE);
      }
      return anyAttribute;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.COMPONENT_TYPE__SERVICES:
               return ((InternalEList) getServices()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.COMPONENT_TYPE__REFERENCES:
               return ((InternalEList) getReferences()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.COMPONENT_TYPE__PROPERTIES:
               return ((InternalEList) getProperties()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.COMPONENT_TYPE__ANY:
               return ((InternalEList) getAny()).basicRemove(otherEnd, msgs);
            case SCAPackage.COMPONENT_TYPE__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.COMPONENT_TYPE__SERVICES:
            return getServices();
         case SCAPackage.COMPONENT_TYPE__REFERENCES:
            return getReferences();
         case SCAPackage.COMPONENT_TYPE__PROPERTIES:
            return getProperties();
         case SCAPackage.COMPONENT_TYPE__ANY:
            return getAny();
         case SCAPackage.COMPONENT_TYPE__ANY_ATTRIBUTE:
            return getAnyAttribute();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.COMPONENT_TYPE__SERVICES:
            getServices().clear();
            getServices().addAll((Collection) newValue);
            return;
         case SCAPackage.COMPONENT_TYPE__REFERENCES:
            getReferences().clear();
            getReferences().addAll((Collection) newValue);
            return;
         case SCAPackage.COMPONENT_TYPE__PROPERTIES:
            getProperties().clear();
            getProperties().addAll((Collection) newValue);
            return;
         case SCAPackage.COMPONENT_TYPE__ANY:
            getAny().clear();
            getAny().addAll((Collection) newValue);
            return;
         case SCAPackage.COMPONENT_TYPE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.COMPONENT_TYPE__SERVICES:
            getServices().clear();
            return;
         case SCAPackage.COMPONENT_TYPE__REFERENCES:
            getReferences().clear();
            return;
         case SCAPackage.COMPONENT_TYPE__PROPERTIES:
            getProperties().clear();
            return;
         case SCAPackage.COMPONENT_TYPE__ANY:
            getAny().clear();
            return;
         case SCAPackage.COMPONENT_TYPE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.COMPONENT_TYPE__SERVICES:
            return services != null && !services.isEmpty();
         case SCAPackage.COMPONENT_TYPE__REFERENCES:
            return references != null && !references.isEmpty();
         case SCAPackage.COMPONENT_TYPE__PROPERTIES:
            return properties != null && !properties.isEmpty();
         case SCAPackage.COMPONENT_TYPE__ANY:
            return any != null && !any.isEmpty();
         case SCAPackage.COMPONENT_TYPE__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (any: "); //$NON-NLS-1$
      result.append(any);
      result.append(", anyAttribute: "); //$NON-NLS-1$
      result.append(anyAttribute);
      result.append(')');
      return result.toString();
   }

   public void unbind() {
      synchronized (this) {
         eSetDeliver(false);

         if (hasIntrospectedProperties)
            getPropertiesGen().clear();
         if (hasIntrospectedServices)
            getServicesGen().clear();
         if (hasIntrospectedReferences)
            getReferencesGen().clear();

         hasIntrospectedProperties = false;
         hasIntrospectedReferences = false;
         hasIntrospectedServices = false;

         eSetDeliver(true);

      }
   }

   public Object resolveImplementation() {
      IComponentTypeIntrospector introspector = findIntrospector();
      return introspector != null ? introspector.resolveImplementation() : null;
   }

   public Reference getReference(String name) {
      if (name != null) {
         List references = getReferences();
         int size = references.size();
         for (int i = 0; i < size; i++) {
            Reference reference = (Reference) references.get(i);
            if (name.equals(reference.getName()))
               return reference;
         }
      }
      return null;
   }

   public Service getService(String serviceName) {
      if (serviceName != null) {
         List services = getServices();
         int size = services.size();
         for (int i = 0; i < size; i++) {
            Service service = (Service) services.get(i);
            if (serviceName.equals(service.getName()))
               return service;
         }
      }
      return null;
   }

   public Service getService(Interface interfaze) {
      if (interfaze != null) {
         List services = getServices();
         int size = services.size();
         for (int i = 0; i < size; i++) {
            Service service = (Service) services.get(i);
            if (interfaze.equals(service.getInterface()))
               return service;
         }
      }
      return null;
   }

   public Property getProperty(String name) {
      if (name != null) {
         List properties = getProperties();
         int size = properties.size();
         for (int i = 0; i < size; i++) {
            Property property = (Property) properties.get(i);
            if (name.equals(property.getName()))
               return property;
         }
      }
      return null;
   }

   /**
    * @return
    */
   private IComponentTypeIntrospector findIntrospector() {
      IComponentTypeIntrospector introspector = (IComponentTypeIntrospector) EcoreUtil
            .getAdapter(eAdapters(), IComponentTypeIntrospector.ADAPTER_TYPE);
      return introspector;
   }

} // ComponentTypeImpl
