/**
 * <copyright> </copyright>
 * 
 * $Id: ModuleFragmentImpl.java,v 1.1 2006/03/31 21:58:48 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.sca.ModuleFragment;
import org.eclipse.stp.core.sca.ModuleWire;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Module Fragment</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.ModuleFragmentImpl#getWires <em>Wires</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ModuleFragmentImpl#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ModuleFragmentImpl#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ModuleFragmentImpl extends CompositeImpl implements ModuleFragment {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright    = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getWires() <em>Wires</em>}' containment
    * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getWires()
    * @generated
    * @ordered
    */
   protected EList            wires        = null;

   /**
    * The cached value of the '{@link #getAny() <em>Any</em>}' attribute list.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAny()
    * @generated
    * @ordered
    */
   protected FeatureMap       any          = null;

   /**
    * The cached value of the '{@link #getAnyAttribute() <em>Any Attribute</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAnyAttribute()
    * @generated
    * @ordered
    */
   protected FeatureMap       anyAttribute = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ModuleFragmentImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getModuleFragment();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getWires() {
      if (wires == null) {
         wires = new EObjectContainmentEList(ModuleWire.class, this,
               SCAPackage.MODULE_FRAGMENT__WIRES);
      }
      return wires;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAny() {
      if (any == null) {
         any = new BasicFeatureMap(this, SCAPackage.MODULE_FRAGMENT__ANY);
      }
      return any;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAnyAttribute() {
      if (anyAttribute == null) {
         anyAttribute = new BasicFeatureMap(this,
               SCAPackage.MODULE_FRAGMENT__ANY_ATTRIBUTE);
      }
      return anyAttribute;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.MODULE_FRAGMENT__ENTRY_POINTS:
               return ((InternalEList) getEntryPoints()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.MODULE_FRAGMENT__COMPONENTS_GROUP:
               return ((InternalEList) getComponentsGroup()).basicRemove(
                     otherEnd, msgs);
            case SCAPackage.MODULE_FRAGMENT__COMPONENTS:
               return ((InternalEList) getComponents()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.MODULE_FRAGMENT__EXTERNAL_SERVICES:
               return ((InternalEList) getExternalServices()).basicRemove(
                     otherEnd, msgs);
            case SCAPackage.MODULE_FRAGMENT__WIRES:
               return ((InternalEList) getWires()).basicRemove(otherEnd, msgs);
            case SCAPackage.MODULE_FRAGMENT__ANY:
               return ((InternalEList) getAny()).basicRemove(otherEnd, msgs);
            case SCAPackage.MODULE_FRAGMENT__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_FRAGMENT__ENTRY_POINTS:
            return getEntryPoints();
         case SCAPackage.MODULE_FRAGMENT__COMPONENTS_GROUP:
            return getComponentsGroup();
         case SCAPackage.MODULE_FRAGMENT__COMPONENTS:
            return getComponents();
         case SCAPackage.MODULE_FRAGMENT__EXTERNAL_SERVICES:
            return getExternalServices();
         case SCAPackage.MODULE_FRAGMENT__NAME:
            return getName();
         case SCAPackage.MODULE_FRAGMENT__WIRES:
            return getWires();
         case SCAPackage.MODULE_FRAGMENT__ANY:
            return getAny();
         case SCAPackage.MODULE_FRAGMENT__ANY_ATTRIBUTE:
            return getAnyAttribute();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_FRAGMENT__ENTRY_POINTS:
            getEntryPoints().clear();
            getEntryPoints().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE_FRAGMENT__COMPONENTS_GROUP:
            getComponentsGroup().clear();
            getComponentsGroup().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE_FRAGMENT__COMPONENTS:
            getComponents().clear();
            getComponents().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE_FRAGMENT__EXTERNAL_SERVICES:
            getExternalServices().clear();
            getExternalServices().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE_FRAGMENT__NAME:
            setName((String) newValue);
            return;
         case SCAPackage.MODULE_FRAGMENT__WIRES:
            getWires().clear();
            getWires().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE_FRAGMENT__ANY:
            getAny().clear();
            getAny().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE_FRAGMENT__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_FRAGMENT__ENTRY_POINTS:
            getEntryPoints().clear();
            return;
         case SCAPackage.MODULE_FRAGMENT__COMPONENTS_GROUP:
            getComponentsGroup().clear();
            return;
         case SCAPackage.MODULE_FRAGMENT__COMPONENTS:
            getComponents().clear();
            return;
         case SCAPackage.MODULE_FRAGMENT__EXTERNAL_SERVICES:
            getExternalServices().clear();
            return;
         case SCAPackage.MODULE_FRAGMENT__NAME:
            setName(NAME_EDEFAULT);
            return;
         case SCAPackage.MODULE_FRAGMENT__WIRES:
            getWires().clear();
            return;
         case SCAPackage.MODULE_FRAGMENT__ANY:
            getAny().clear();
            return;
         case SCAPackage.MODULE_FRAGMENT__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_FRAGMENT__ENTRY_POINTS:
            return entryPoints != null && !entryPoints.isEmpty();
         case SCAPackage.MODULE_FRAGMENT__COMPONENTS_GROUP:
            return componentsGroup != null && !componentsGroup.isEmpty();
         case SCAPackage.MODULE_FRAGMENT__COMPONENTS:
            return !getComponents().isEmpty();
         case SCAPackage.MODULE_FRAGMENT__EXTERNAL_SERVICES:
            return externalServices != null && !externalServices.isEmpty();
         case SCAPackage.MODULE_FRAGMENT__NAME:
            return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
                  .equals(name);
         case SCAPackage.MODULE_FRAGMENT__WIRES:
            return wires != null && !wires.isEmpty();
         case SCAPackage.MODULE_FRAGMENT__ANY:
            return any != null && !any.isEmpty();
         case SCAPackage.MODULE_FRAGMENT__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (any: "); //$NON-NLS-1$
      result.append(any);
      result.append(", anyAttribute: "); //$NON-NLS-1$
      result.append(anyAttribute);
      result.append(')');
      return result.toString();
   }

} // ModuleFragmentImpl
