/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.util;

import java.io.Serializable;

public class ReferenceOrServiceField implements Serializable {
   private static final long serialVersionUID = 1L;

   String                    name             = null;

   InterfaceField            interfaceField   = null;

   public ReferenceOrServiceField(String name, Object interfaceObject) {
      this.name = name;
      this.interfaceField = new InterfaceField(interfaceObject);
   }

   public String toString() {
      StringBuffer s = new StringBuffer();
      s.append(" "); //$NON-NLS-1$
      s.append(name);
      s.append(" : "); //$NON-NLS-1$
      s.append(interfaceField.toString());

      return s.toString();
   }

   public String getName() {
      return name;
   }

   // public InterfaceField getInterface() {
   // return interfaceField;
   // }

   public Object getInterfaceObject() {
      return interfaceField.getInterfaceObject();
   }
}
