/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.saf.handler;

import java.net.URL;

/**
 * This class provides a common interface for all handlers contributed to the
 * framework.
 */
public interface IHandler {

	/**
	 * Returns a string corresponding to a component, external service, entry
	 * point, or interface kind. This string acts as an identifier for a
	 * component, external service, entry point, or interface handler (the
	 * handler registered to process the specified kind).
	 * 
	 * @return the QName string of the implementation kind of a component, or
	 *         the binding kind of an external service or entry point, or an
	 *         interface kind of an SCA interface
	 */
	public String getKind();
	
	/**
	 * Returns a string describing the handler kind. This string is translated
	 * and is suitable for user dialogs and messages. For instance, if a given
	 * object can be processed by several different types of handlers, such as
	 * component and interface handlers, the user must be presented with a set of
	 * available choices. These choices can be worded using the descriptive kind
	 * name.
	 * 
	 * @return the descriptive kind name for this handler
	 */
	public String getDescriptiveKindName();
	
	/**
	 * Returns a name for the component, external service, entry point, or
	 * interface kind. This string is intended to be suitable for display to an
	 * end user.
	 * 
	 * @return the name of the implementation kind of a component, or the
	 *         binding kind of an external service or entry point, or the
	 *         interface kind of an SCA interface.
	 */
	public String getName();

	/**
	 * Returns text that describes the component, external service, entry point,
	 * or interface kind. This string is intended to be suitable for display to
	 * an end user.
	 * 
	 * @return the description for the implementation kind of a component, or
	 *         the binding kind of an external service or entry point, or the
	 *         interface kind of an SCA interface
	 */
	public String getDescription();

	/**
	 * Returns the URL for the small icon resource thet represents the
	 * corresponding component, entry point, external service, or interface kind.
	 * The image is intended to be suitable for display to an end user.
	 * 
	 * @return URL for icon resource
	 */
	public URL getSmallIcon();

	/**
	 * Returns the URL for the large icon resource thet represents the
	 * corresponding component, entry point, external service, or interface kind.
	 * The image is intended to be suitable for display to an end user.
	 * 
	 * @return URL for icon resource
	 */
	public URL getLargeIcon();
	
}
