/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.common.validator;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.w3c.dom.Document;

/**
 * This class is used to validate one annotation according to its schema
 * This link beween annotation and it is schema is decidec by the namespace 
 * generted from full name of the annotation class 
 * @author jma
 *
 */
public class AnnotationValidator {
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(AnnXMLTreeBuilder.class);
	
	AnnXMLTreeBuilder treeBuilder;
	XMLSchemaValidator schemaValidator;
	CompilationUnit astRoot = null;
	
	public AnnotationValidator() {
		treeBuilder = new AnnXMLTreeBuilder();
		schemaValidator = new XMLSchemaValidator(); 
	}
	
    public boolean validateAnn(NormalAnnotation ann) {
    	
    	Document doc = treeBuilder.buildTreeFromOneAnn(ann);
    	if(doc == null) {
    		LOG.error("can't generate xml from ann. return true for validation for now");
    		return true;
    	}   	
    	return schemaValidator.validateXML(doc);
    }
    
    public String getLastErrorMessage() {
    	return schemaValidator.getErrorMessage();
    }
}
