/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * 
 * @author amiguel
 *
 * A hashmap alternative where rather than specifying the key,
 * the key is returned by the PUT method.  This lends to optimizations
 * for retrieval.
 */
public class IndexMap {

Object lock = new Object();
	
UIDPool pool = new UIDPool();
	
ArrayList dat = new ArrayList();

	public int put(Object o) {
		synchronized(lock) {
				
			int key = pool.getUID();
			if (key == dat.size()) {
				dat.add(o);
			} else {
				dat.set(key,o);
			}
			return key;
			
		}
	}
	public Object get(int key) {
		synchronized(lock) {
			return dat.get(key);
		}
	}
	public void remove(int key) {
		pool.releaseUID(key);
	}
	
	static class HashMapRunnable implements Runnable {
		Object[] keys;
		HashMap map;
		public void run() {
			for (int i = 0; i < keys.length; i++) {
				map.get(keys[i]);
			}
		}
	}
	static class IndexMapRunnable implements Runnable {
		int[] keys;
		IndexMap map;
		public void run() {
			for (int i = 0; i < keys.length; i++) {
				map.get(keys[i]);
			}
		}
	}
	
	public static void main(String[] args) {
		HashMap t1 = new HashMap();
		IndexMap t2 = new IndexMap();
		
		int n = Integer.parseInt(args[0]);
		
		int[] ikeys = new int[n];
		Object[] hkeys = new Object[n];
		
		for (int i = 0; i < n; i++) {
			Object val = new Object();
			
			ikeys[i] = t2.put(val);
			hkeys[i] = new Object();
			t1.put(hkeys[i],val);
		}

		IndexMapRunnable irun = new IndexMapRunnable();
		HashMapRunnable hrun = new HashMapRunnable();
		
		irun.keys = ikeys;
		irun.map = t2;
		hrun.keys = hkeys;
		hrun.map = t1;
		
		System.out.println("IndexMap/HashMap = "+SpeedComparator.compare(irun,hrun,1000));
	}
}