/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.xml.internal;

import java.util.HashMap;

public interface XMLParserListener {
	public void startElement(String tag, HashMap h, int lineno) throws Exception;
	public void endElement(String tag, int lineno) throws Exception;
	public void startDocument() throws Exception;
	public void endDocument() throws Exception;
	public void text(String str, int linefrom, int lineto) throws Exception;
	public void comment(String str, int linefrom, int lineto) throws Exception;
}
