/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.editor;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

/**
 * Manages the installation/deinstallation of global actions for multi-page editors.
 * Responsible for the redirection of global actions to the active editor.
 * Multi-page contributor replaces the contributors for the individual editors in the multi-page editor.
 */
public class XefEditorContributor extends MultiPageEditorActionBarContributor {
	private IEditorPart activeEditorPart;
    private XefEditor editor;
	/**
	 * Creates a multi-page contributor.
	 */
	public XefEditorContributor() {
		super();
	}
	/**
	 * Returns the action registed with the given text editor.
	 * @return IAction or null if editor is null.
	 */
	protected IAction getAction(ITextEditor textEditor, String actionID) {
		return (textEditor == null ? null : textEditor.getAction(actionID));
	}

    protected IAction getAction(XefEditPage guiEditor, String actionID) {
        return (guiEditor == null ? null : guiEditor.block.getAction(actionID));
    }
    /* (non-JavaDoc)
	 * Method declared in AbstractMultiPageEditorActionBarContributor.
	 */

    @Override
	public void setActivePage(IEditorPart part) {
		if (activeEditorPart == part) {
			return;
        }
		
		activeEditorPart = part;               

		IActionBars actionBars = getActionBars();
		if (actionBars != null) {
            if (part instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor) part;
//                ITextEditor editor = (part instanceof ITextEditor) ? (ITextEditor) part : null;
    
			actionBars.setGlobalActionHandler(
				ActionFactory.DELETE.getId(),
				getAction(textEditor, ITextEditorActionConstants.DELETE));
			actionBars.setGlobalActionHandler(
				ActionFactory.UNDO.getId(),
				getAction(textEditor, ITextEditorActionConstants.UNDO));
			actionBars.setGlobalActionHandler(
				ActionFactory.REDO.getId(),
				getAction(textEditor, ITextEditorActionConstants.REDO));
			actionBars.setGlobalActionHandler(
				ActionFactory.CUT.getId(),
				getAction(textEditor, ITextEditorActionConstants.CUT));
			actionBars.setGlobalActionHandler(
				ActionFactory.COPY.getId(),
				getAction(textEditor, ITextEditorActionConstants.COPY));
			actionBars.setGlobalActionHandler(
				ActionFactory.PASTE.getId(),
				getAction(textEditor, ITextEditorActionConstants.PASTE));
			actionBars.setGlobalActionHandler(
				ActionFactory.SELECT_ALL.getId(),
				getAction(textEditor, ITextEditorActionConstants.SELECT_ALL));
			actionBars.setGlobalActionHandler(
				ActionFactory.FIND.getId(),
				getAction(textEditor, ITextEditorActionConstants.FIND));
			actionBars.setGlobalActionHandler(
				IDEActionFactory.BOOKMARK.getId(),
				getAction(textEditor, IDEActionFactory.BOOKMARK.getId()));
            } else {
                XefEditPage guiEditor = editor.policyEditPage;
                
                actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), getAction(guiEditor,
                        ActionFactory.DELETE.getId()));
                actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), getAction(guiEditor,
                        ActionFactory.UNDO.getId()));
                actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), getAction(guiEditor,
                        ActionFactory.REDO.getId()));
                actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), getAction(guiEditor,
                        ActionFactory.CUT.getId()));
                actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), getAction(guiEditor,
                        ActionFactory.COPY.getId()));
                actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), getAction(guiEditor,
                        ActionFactory.PASTE.getId()));
                actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), getAction(guiEditor,
                        ActionFactory.SELECT_ALL.getId()));
                actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), getAction(guiEditor,
                        ActionFactory.FIND.getId()));
                actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), getAction(guiEditor,
                        IDEActionFactory.BOOKMARK.getId()));                
            }
			actionBars.updateActionBars();
		}
	}
// private void createActions() {
// sampleAction = new Action() {
// public void run() {
// MessageDialog.openInformation(null, "PolicyEdit Plug-in", "Sample Action
// Executed");
// }
// };
// sampleAction.setText("Sample Action");
//		sampleAction.setToolTipText("Sample Action tool tip");
//		sampleAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
//				getImageDescriptor(IDE.SharedImages.IMG_OBJS_TASK_TSK));
//	}
//	public void contributeToMenu(IMenuManager manager) {
//		IMenuManager menu = new MenuManager("Editor &Menu");
//		manager.prependToGroup(IWorkbenchActionConstants.MB_ADDITIONS, menu);
//		menu.add(sampleAction);
//	}
//	public void contributeToToolBar(IToolBarManager manager) {
//		manager.add(new Separator());
//		manager.add(sampleAction);
//	}
    @Override
    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        
        if (part instanceof XefEditor) {
            editor = (XefEditor) part;
        }
    }
}
