/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.internal.extensions.bpelprovider;

import org.eclipse.stp.b2j.ui.internal.misc.PathUtil;
import org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider.BPELProvider;
import org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider.PropertySource;
import org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider.PropertySourceUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WorkspaceFile implements BPELProvider {

	String filename;
	PropertySource source;
	
	public PropertySourceUI getPropertySourceUI() {
		return new WorkspaceFileUI();
	}

	public void setPropertySource(PropertySource source) {
		this.source = source;

		Document doc = source.getProperty(WorkspaceFileUI.PROPERTY_NAME);
		Element elem = doc.getDocumentElement();
		filename = elem.getAttribute("file");
	}

	public String getBpelName() {
		String name = filename.substring(Math.max(filename.lastIndexOf('\\'),filename.lastIndexOf('/')) + 1);
		return name;
	}

	public String getBpelSource() throws Exception {
		String bpel_source = PathUtil.readFileFromPath(filename);
		return bpel_source;
	}
	
	public String getBpelUri() throws Exception {
		return PathUtil.getLocationFromPath(filename);
	}
}