/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.core.sync;

/**
 * 
 * @author amiguel
 * 
 * Part of the generic runtime engine API, implements a Mutex synchronization
 * construct which can be shared and accessed by any part of the engine.
 */
public class SharedMutex {

public SharedSemaphore sem;

	public SharedMutex(SharedSemaphore sem) {
		this.sem = sem;	
	}
	
	public void lock() throws Exception {
		sem.semWait(1);	
	}
	
	public void release() throws Exception {
		sem.semSignal(1);	
	}
	
}