/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.BPELCorrelationSet;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPClientTransport;
import org.eclipse.stp.b2j.core.jengine.internal.utils.UIDPool;

/**
 * 
 * @author amiguel
 *
 * A HTTP transport implementation used by the SOAP binding
 */
public class SOAPClientTransportHTTP implements SOAPClientTransport {

	//this map provides
	UIDPool instances = new UIDPool();
	
	final static long TIMEOUT = 30000;	//30 sec timeout
	
	URL address;
	boolean rpc_type = false;

	String[][] headers = new String[][] {
			{"SOAPAction",""}
	};
	
	BPELCorrelationSet cset;
	String correlationKey;

	String proxy_host = null;
	int proxy_port = -1;
	
	public SOAPClientTransportHTTP(String address, BPELCorrelationSet cset, String proxy_host, int proxy_port, String[] excluded_hosts) throws MalformedURLException {
		this.address = new URL(address);
		this.cset = cset;
		this.proxy_host = proxy_host;
		this.proxy_port = proxy_port;
		
		String lchost = this.address.getHost().toLowerCase();
		for (int i = 0; i < excluded_hosts.length; i++) {
			String lcexc = excluded_hosts[i].toLowerCase();
			int lclen = lcexc.length();
			
			if (lclen > 0) {
				if (lchost.equals(lcexc)) {
					//direct equals
					this.proxy_host = null;
					this.proxy_port = -1;
				} else if (lcexc.charAt(0) == '*') {
					if (lcexc.charAt(lclen-1) == '*') {
						//star at both ends
						if (lchost.indexOf(lcexc.substring(1,lclen-1)) != -1) {
							this.proxy_host = null;
							this.proxy_port = -1;
						}
					} else {
						//start at beginning only
						if (lchost.endsWith(lcexc.substring(1))) {
							this.proxy_host = null;
							this.proxy_port = -1;
						}
					}
				} else if (lcexc.charAt(lclen-1) == '*') {
					//start at end only
					if (lchost.startsWith(lcexc.substring(0,lclen-1))) {
						this.proxy_host = null;
						this.proxy_port = -1;
					}
				}
			}
		}
		
		if (cset != null) {
			correlationKey = cset.toString();
		} else {
			correlationKey = null;
		}
	}

	public void send(String xml, String soapAction) throws Exception {
		headers[0][1] = soapAction;
		
		if (proxy_host == null) {
			//(ignore response)
			HTTPClientPool.doPost(address,xml.getBytes("UTF-8"),"text/xml",headers,correlationKey);
		} else {
			//(ignore response)
			HTTPClientPool.doPost(address,xml.getBytes("UTF-8"),"text/xml",headers,proxy_host,proxy_port,correlationKey,null);
		}
	}
	
	public String sendAndReceive(String xml, String soapAction) throws Exception {
		headers[0][1] = soapAction;
		
		if (proxy_host == null) {
			return new String(HTTPClientPool.doPost(address,xml.getBytes("UTF-8"),"text/xml",headers,correlationKey),"UTF-8");
		} else {
			return new String(HTTPClientPool.doPost(address,xml.getBytes("UTF-8"),"text/xml",headers,proxy_host,proxy_port,correlationKey,null),"UTF-8");
		}
	}
	
	public void close() {
	}
}