/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.mutex;

import java.io.IOException;
import java.util.LinkedList;

/**
 * 
 * @author amiguel
 *
 * An object list that can have objects dropped in at any time but
 * which a thread can read from in a blocking manner.
 * 
 * Does not support multiple threads reading at once
 */
public class ObjectBuffer {

LinkedList buffer = new LinkedList();

Object lock = new Object();
Object notifier = new Object();	

IOException ioexception = null;

	private void waitForData() {
		synchronized (notifier) {
			while(buffer.size() == 0 && ioexception == null) {
				try {
					notifier.wait();
				} catch (InterruptedException e) {}
			}
		}
	}
	
	public boolean contains(Object o) {
		synchronized(lock) {
			for (int i = 0; i < buffer.size(); i++) {
				if (o.equals(buffer.get(i))) {
					return true;
				}
			}
		}
		return false;
	}

	public void clear() {
		synchronized(lock) {
			buffer = new LinkedList();	
		}
	}

	public boolean hasNext() {
		return buffer.size() > 0;
	}

	public Object next() throws IOException {
		waitForData();
		if (ioexception != null) throw ioexception;
		synchronized(lock) {
			return buffer.remove(0);
		}	
	}

	public void add(Object o) {
		synchronized(lock) {
			buffer.add(o);
		}
		synchronized(notifier) {
			notifier.notify();
		}
	}

	public void setError(IOException t) {
		ioexception = t;
		synchronized(notifier) {
			notifier.notify();
		}
	}	
}