/******************************************************************************
 * Copyright (c) 2006-2007 Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.bpmn.figures;

import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.stp.bpmn.figures.activities.ActivityPainter;

/**
 * Wrap label that maintains its tooltip.
 * 
 * @author hmalphettes
 * @author Intalio Inc.
 */
public class WrapLabelWithToolTip extends WrapLabel {

    /**
     */
    public interface IToolTipProvider {
        /**
         * @param currentTextIsTruncated true when the label is truncated.
         * @return The tooltip to use.
         */
        public String getToolTipText(boolean currentTextIsTruncated);
        
    }
    
    private final IToolTipProvider _toolTipProvider;
    private String _lastToolTip;
    
    /**
     * @param toolTipProvider
     */
    public WrapLabelWithToolTip(IToolTipProvider toolTipProvider) {
        _toolTipProvider = toolTipProvider;
    }
    
    /**
     * refresh the tooltip if necessary
     */
    private void updateToolTip(String sub) {
        //when we use the method provided by WrapLabel all kind of issue ariase.
        //not sure why they need to compute the size of the font to see
        //if it gets truncated or not
        boolean trunc = sub != null && sub.length() > 0 && !sub.equals(getText());
        
        String newToolTip = _toolTipProvider.getToolTipText(trunc);
        if (newToolTip == null) {
            if (_lastToolTip != null) {
                _lastToolTip = null;
                setToolTip(ActivityPainter.createToolTipFigure(_lastToolTip));
            }
        } else if (!newToolTip.equals(_lastToolTip)) {
            _lastToolTip = newToolTip;
            setToolTip(ActivityPainter.createToolTipFigure(_lastToolTip));
        }
        
    }

    @Override
    public String getSubStringText() {
        String sub = super.getSubStringText();
        updateToolTip(sub);
        return sub;
    }
    
    
    
}
