package org.eclipse.stp.bpmn.policies;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.Association;
import org.eclipse.stp.bpmn.IdentifiableNode;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.tools.EdgeConnectionValidator;
import org.eclipse.stp.bpmn.tools.MessageConnectionValidator;

/**
 * Basic command to reconnect.
 * 
 * @author hmalphettes
 * @authr Intalio Inc.
 */
public class BpmnReorientRelationshipCommand extends Command {
    
    private final ReorientRelationshipRequest _req;
    
    public BpmnReorientRelationshipCommand(ReorientRelationshipRequest req) {
        super("reorient relationship");
        _req = req;
    }

    @Override
    public boolean canExecute() {
        return canExecute(_req.getNewRelationshipEnd(), _req.getOldRelationshipEnd());
    }
    private boolean canExecute(EObject newEnd, EObject oldEnd) {
        if (newEnd != null && oldEnd != null && newEnd != oldEnd) {
            if (_req.getRelationship() instanceof Association) {
                if (_req.getDirection() == ReorientRelationshipRequest.REORIENT_SOURCE) {
                    if (newEnd instanceof Artifact) {
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    if (newEnd instanceof IdentifiableNode) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else if (_req.getRelationship() instanceof SequenceEdge) {
                if (newEnd instanceof Activity) {
                    Activity act = (Activity)newEnd;
                    if (act.getActivityType().getValue() != ActivityType.SUB_PROCESS) {
                        return true;
                    }
                    if (_req.getDirection() == ReorientRelationshipRequest.REORIENT_TARGET) {
                        return EdgeConnectionValidator.INSTANCE.canConnect(
                                ((SequenceEdge)_req.getRelationship()).getSource(), act);
                    } else {
                        return EdgeConnectionValidator.INSTANCE.canConnect(act,
                                ((SequenceEdge)_req.getRelationship()).getTarget());
                    }
                }
            } else if (_req.getRelationship() instanceof MessagingEdge) {
                if (newEnd instanceof Activity) {
                    Activity act = (Activity)newEnd;
                    if (_req.getDirection() == ReorientRelationshipRequest.REORIENT_TARGET) {
                        return MessageConnectionValidator.INSTANCE.canConnect(
                                ((MessagingEdge)_req.getRelationship()).getSource(), act);
                    } else {
                        return MessageConnectionValidator.INSTANCE.canConnect(act,
                                ((MessagingEdge)_req.getRelationship()).getTarget());
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean canUndo() {
        return canExecute(_req.getOldRelationshipEnd(), _req.getNewRelationshipEnd());
    }

    @Override
    public void execute() {
        connect(_req.getNewRelationshipEnd(), _req.getOldRelationshipEnd());
    }

    @Override
    public void undo() {
        connect(_req.getOldRelationshipEnd(), _req.getNewRelationshipEnd());
    }
    
    private void connect(EObject newEnd, EObject oldEnd) {
        if (_req.getRelationship() instanceof Association) {
            if (_req.getDirection() == ReorientRelationshipRequest.REORIENT_SOURCE) {
                ((Association)_req.getRelationship()).setSource((Artifact)newEnd);
            } else {
                ((Association)_req.getRelationship()).setTarget((IdentifiableNode)newEnd);
            }
        } else if (_req.getRelationship() instanceof SequenceEdge) {
            if (_req.getDirection() == ReorientRelationshipRequest.REORIENT_SOURCE) {
                ((SequenceEdge)_req.getRelationship()).setSource((Vertex)newEnd);
            } else {
                ((SequenceEdge)_req.getRelationship()).setTarget((Vertex)newEnd);
            }
        } else if (_req.getRelationship() instanceof MessagingEdge) {
            if (_req.getDirection() == ReorientRelationshipRequest.REORIENT_SOURCE) {
                ((MessagingEdge)_req.getRelationship()).setSource((Activity)newEnd);
            } else {
                ((MessagingEdge)_req.getRelationship()).setTarget((Activity)newEnd);
            }
        }
    }

}
