/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.operations;

import java.util.Set;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.internal.saf.impl.Messages;
import org.eclipse.stp.core.internal.saf.impl.SAFActivator;
import org.eclipse.stp.core.saf.exception.InvalidOperationException;
import org.eclipse.stp.core.sca.AbstractImplementation;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

/**
 * 
 */
public class ComponentTypingDataModelProvider extends AbstractDataModelProvider implements IComponentTypingDataModelProperties {

	/**
	 * 
	 */
	public ComponentTypingDataModelProvider() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel#getDefaultOperation()
	 */
	public IDataModelOperation getDefaultOperation() {
		if (model == null)
			model = DataModelFactory.createDataModel(this);	
		
		return new ComponentTypingOperation(model);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider#getPropertyNames()
	 */
	public Set getPropertyNames() {
		Set propertyNames = super.getPropertyNames();
		
		propertyNames.add(SET_TYPE);
		propertyNames.add(TYPE);
		propertyNames.add(COMPONENT);
		
		return propertyNames;	
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel#getDefaultProperty(java.lang.String)
	 */
	public Object getDefaultProperty(String propertyName) {
		if (SET_TYPE.equals(propertyName))
			return new Boolean(false);
		
		return super.getDefaultProperty(propertyName);
	}	
	
	public IStatus validate(String propertyName) {

		if (propertyName.equals(COMPONENT)){
			
			Component component = (Component)model.getProperty(IComponentTypingDataModelProperties.COMPONENT);
			boolean setType = model.getBooleanProperty(IComponentTypingDataModelProperties.SET_TYPE);
			String type = model.getStringProperty(IComponentTypingDataModelProperties.TYPE);
						
			Implementation oldImplementation = component.getImplementation();
	
			if (setType && oldImplementation != null && !(oldImplementation instanceof AbstractImplementation)){
				String message = NLS.bind(Messages.stp_core_saf_unableToSetKindForTypedComponent, type);
				return SAFActivator.createErrorStatus(message, new InvalidOperationException(message));
			}
	     
	        return Status.OK_STATUS;
		}
		
    	return super.validate(propertyName);
	}
}
