/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.saf;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.core.sca.SCAObject;


/**
 * This class is used to filter the handler result set, returned by
 * {@link ISAFManager}, based on the type of model (service model, 
 * implementation model, etc.) being authored.
 * 
 */
public class Context {

	private String namespace;

	private String rootType;

	private String subType;

	/**
	 * @param namespace -
	 *            context namespace URI
	 * @param rootType -
	 *            context root type
	 * @param subType -
	 *            context sub type
	 */
	public Context(String namespace, String rootType, String subType) {
		this.namespace = namespace;
		this.rootType = rootType;
		this.subType = subType;
	}

	/**
	 * @param rootObject
	 *            the object used to derive the context namespace and root type.
	 *            These fields are obtained from the {@link EClass} associated
	 *            with the {@link EObject} obtained from
	 *            {@link SCAObject#getEObject()}.
	 * @param subType
	 *            context sub type
	 */
	public Context(SCAObject rootObject, String subType) {
		this.namespace = rootObject.getEObject().eClass().getEPackage().getNsURI();
		this.rootType = rootObject.getEObject().eClass().getName();
		this.subType = subType;
	}

	/**
	 * @return the sub type for this context
	 */
	public String getSubType() {
		return subType;
	}

	/**
	 * @return the namespace for this context
	 */
	public String getNamespace() {
		return namespace;
	}

	/**
	 * @return the root type for this context
	 */
	public String getRootType() {
		return rootType;
	}

}
