/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.delete.operations;

import java.util.List;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerOperation;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class DeleteReferenceOperation extends AbstractScribblerOperation {
   public DeleteReferenceOperation(IDataModel model) {
      super(model);
   }

   protected IStatus doExecute(IProgressMonitor monitor)
         throws ExecutionException {
      ComponentType cType = (ComponentType) model
            .getProperty(IDeleteReferenceDataModelProperties.COMPONENT_TYPE);

      if (model
            .isPropertySet(IDeleteReferenceDataModelProperties.REFERENCE_NAMES)
            && model
                  .isPropertySet(IDeleteReferenceDataModelProperties.COMPONENT_TYPE)) {

         List references = cType.getReferences();
         if (references.isEmpty())
            return OK_STATUS;

         String[] referenceNames = (String[]) model
               .getProperty(IDeleteReferenceDataModelProperties.REFERENCE_NAMES);
         Assert.isTrue(references.size() >= referenceNames.length);
         for (int i = 0; i < referenceNames.length; i++) {
            Reference reference = null;

            for (int referenceIndex = 0; referenceIndex < references.size(); referenceIndex++) {
               reference = (Reference) references.get(referenceIndex);
               if (reference.getName().equals(referenceNames[i]))
                  break;

               reference = null;
            }

            if (reference != null) {
               cType.getReferences().remove(reference);
            }
         }
      }

      return OK_STATUS;
   }

   protected IStatus doRedo(IProgressMonitor monitor) throws ExecutionException {
      // TODO Auto-generated method stub
      return null;
   }

   protected IStatus doUndo(IProgressMonitor monitor) throws ExecutionException {
      // TODO Auto-generated method stub
      return null;
   }
}
