/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.delete.operations;

import java.util.List;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerOperation;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class DeleteServiceOperation extends AbstractScribblerOperation {
   public DeleteServiceOperation(IDataModel model) {
      super(model);
   }

   protected IStatus doExecute(IProgressMonitor monitor)
         throws ExecutionException {
      IStatus status = OK_STATUS;
      ComponentType cType = (ComponentType) model
            .getProperty(IDeleteServiceDataModelProperties.COMPONENT_TYPE);
      List services = cType.getServices();
      if (services.isEmpty())
         return OK_STATUS;

      String[] serviceNames = (String[]) model
            .getProperty(IDeleteServiceDataModelProperties.SERVICE_NAMES);
      Assert.isTrue(services.size() >= serviceNames.length);
      for (int i = 0; i < serviceNames.length; i++) {
         Service service = null;

         for (int serviceIndex = 0; serviceIndex < services.size(); serviceIndex++) {
            service = (Service) services.get(serviceIndex);
            if (service.getName().equals(serviceNames[i]))
               break;

            service = null;
         }

         if (service != null) {
            cType.getServices().remove(service);
         }
      }

      return status;
   }

   protected IStatus doRedo(IProgressMonitor monitor) throws ExecutionException {
      // TODO Auto-generated method stub
      return null;
   }

   protected IStatus doUndo(IProgressMonitor monitor) throws ExecutionException {
      // TODO Auto-generated method stub
      return null;
   }
}
