/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

/**
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 */
public interface IConstants {

   /**
    * The separater character used by wire URIs.
    */
   char             WIRE_PATH_SEP          = '/';

   /**
    * Constant representing the absence of any flag
    */
   int              F_DEFAULT              = 0;

   /**
    * Constant representing the a possibility of being a source for a Wire.
    * 
    * @see org.eclipse.stp.core.sca.WireSource
    */
   int              F_POSSIBLE_WIRE_SOURCE = 0x0001;

   /**
    * Constant representing the a possibility of being a target of a Wire.
    * 
    * @see org.eclipse.stp.core.sca.WireTarget
    */
   int              F_POSSIBLE_WIRE_TARGET = 0x0002;

   /**
    * Constant representing an SOAObject that represents incoming or outgoing
    * service invocations (e.g., {@link org.eclipse.stp.core.sca.EntryPoint},
    * {@link org.eclipse.stp.core.sca.ExternalService}).
    */
   int              F_BOUNDARY_ELEMENT     = 0x0004;

   /**
    * Indicates an element is 'bindable'. A 'bindable' element is either a
    * {@link ModuleService} or a {@link ModuleReference}
    */
   static final int F_BINDABLE_ELEMENT     = 0x0008;

}
