/**
 * <copyright> </copyright>
 * 
 * $Id: SCAAdapterFactory.java,v 1.1 2006/03/31 21:58:50 melder Exp $
 */
package org.eclipse.stp.core.sca.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.core.sca.AbstractImplementation;
import org.eclipse.stp.core.sca.Binding;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.ImplementationComponent;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaImplementation;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Module;
import org.eclipse.stp.core.sca.ModuleComponent;
import org.eclipse.stp.core.sca.ModuleFragment;
import org.eclipse.stp.core.sca.ModuleReference;
import org.eclipse.stp.core.sca.ModuleService;
import org.eclipse.stp.core.sca.ModuleWire;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.PropertyValue;
import org.eclipse.stp.core.sca.PropertyValuesSet;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.ReferenceValue;
import org.eclipse.stp.core.sca.ReferenceValuesSet;
import org.eclipse.stp.core.sca.SCABinding;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.SLSBBinding;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.sca.Subsystem;
import org.eclipse.stp.core.sca.SystemWire;
import org.eclipse.stp.core.sca.UnknownImplementation;
import org.eclipse.stp.core.sca.WSDLPortType;
import org.eclipse.stp.core.sca.WebServiceBinding;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory</b> for the model. It
 * provides an adapter <code>createXXX</code> method for each class of the
 * model. <!-- end-user-doc -->
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage
 * @generated
 */
public class SCAAdapterFactory extends AdapterFactoryImpl {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String  copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached model package. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected static SCAPackage modelPackage;

   /**
    * Creates an instance of the adapter factory. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   public SCAAdapterFactory() {
      if (modelPackage == null) {
         modelPackage = SCAPackage.eINSTANCE;
      }
   }

   /**
    * Returns whether this factory is applicable for the type of the object.
    * <!-- begin-user-doc --> This implementation returns <code>true</code> if
    * the object is either the model's package or is an instance object of the
    * model. <!-- end-user-doc -->
    * 
    * @return whether this factory is applicable for the type of the object.
    * @generated
    */
   public boolean isFactoryForType(Object object) {
      if (object == modelPackage) {
         return true;
      }
      if (object instanceof EObject) {
         return ((EObject) object).eClass().getEPackage() == modelPackage;
      }
      return false;
   }

   /**
    * The switch the delegates to the <code>createXXX</code> methods. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected SCASwitch modelSwitch = new SCASwitch() {
                                      public Object caseAbstractImplementation(
                                            AbstractImplementation object) {
                                         return createAbstractImplementationAdapter();
                                      }

                                      public Object caseBinding(Binding object) {
                                         return createBindingAdapter();
                                      }

                                      public Object caseComponent(
                                            Component object) {
                                         return createComponentAdapter();
                                      }

                                      public Object caseComponentType(
                                            ComponentType object) {
                                         return createComponentTypeAdapter();
                                      }

                                      public Object caseComposite(
                                            Composite object) {
                                         return createCompositeAdapter();
                                      }

                                      public Object caseEntryPoint(
                                            EntryPoint object) {
                                         return createEntryPointAdapter();
                                      }

                                      public Object caseExternalService(
                                            ExternalService object) {
                                         return createExternalServiceAdapter();
                                      }

                                      public Object caseImplementation(
                                            Implementation object) {
                                         return createImplementationAdapter();
                                      }

                                      public Object caseImplementationComponent(
                                            ImplementationComponent object) {
                                         return createImplementationComponentAdapter();
                                      }

                                      public Object caseInterface(
                                            Interface object) {
                                         return createInterfaceAdapter();
                                      }

                                      public Object caseJavaImplementation(
                                            JavaImplementation object) {
                                         return createJavaImplementationAdapter();
                                      }

                                      public Object caseJavaInterface(
                                            JavaInterface object) {
                                         return createJavaInterfaceAdapter();
                                      }

                                      public Object caseModule(Module object) {
                                         return createModuleAdapter();
                                      }

                                      public Object caseModuleComponent(
                                            ModuleComponent object) {
                                         return createModuleComponentAdapter();
                                      }

                                      public Object caseModuleFragment(
                                            ModuleFragment object) {
                                         return createModuleFragmentAdapter();
                                      }

                                      public Object caseModuleReference(
                                            ModuleReference object) {
                                         return createModuleReferenceAdapter();
                                      }

                                      public Object caseModuleService(
                                            ModuleService object) {
                                         return createModuleServiceAdapter();
                                      }

                                      public Object caseModuleWire(
                                            ModuleWire object) {
                                         return createModuleWireAdapter();
                                      }

                                      public Object caseProperty(Property object) {
                                         return createPropertyAdapter();
                                      }

                                      public Object casePropertyValue(
                                            PropertyValue object) {
                                         return createPropertyValueAdapter();
                                      }

                                      public Object casePropertyValuesSet(
                                            PropertyValuesSet object) {
                                         return createPropertyValuesSetAdapter();
                                      }

                                      public Object caseReference(
                                            Reference object) {
                                         return createReferenceAdapter();
                                      }

                                      public Object caseReferenceValue(
                                            ReferenceValue object) {
                                         return createReferenceValueAdapter();
                                      }

                                      public Object caseReferenceValuesSet(
                                            ReferenceValuesSet object) {
                                         return createReferenceValuesSetAdapter();
                                      }

                                      public Object caseSCABinding(
                                            SCABinding object) {
                                         return createSCABindingAdapter();
                                      }

                                      public Object caseSCACoreRoot(
                                            SCACoreRoot object) {
                                         return createSCACoreRootAdapter();
                                      }

                                      public Object caseService(Service object) {
                                         return createServiceAdapter();
                                      }

                                      public Object caseSLSBBinding(
                                            SLSBBinding object) {
                                         return createSLSBBindingAdapter();
                                      }

                                      public Object caseSubsystem(
                                            Subsystem object) {
                                         return createSubsystemAdapter();
                                      }

                                      public Object caseSystemWire(
                                            SystemWire object) {
                                         return createSystemWireAdapter();
                                      }

                                      public Object caseUnknownImplementation(
                                            UnknownImplementation object) {
                                         return createUnknownImplementationAdapter();
                                      }

                                      public Object caseWebServiceBinding(
                                            WebServiceBinding object) {
                                         return createWebServiceBindingAdapter();
                                      }

                                      public Object caseWSDLPortType(
                                            WSDLPortType object) {
                                         return createWSDLPortTypeAdapter();
                                      }

                                      public Object defaultCase(EObject object) {
                                         return createEObjectAdapter();
                                      }
                                   };

   /**
    * Creates an adapter for the <code>target</code>. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @param target
    *           the object to adapt.
    * @return the adapter for the <code>target</code>.
    * @generated
    */
   public Adapter createAdapter(Notifier target) {
      return (Adapter) modelSwitch.doSwitch((EObject) target);
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.AbstractImplementation <em>Abstract Implementation</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.AbstractImplementation
    * @generated
    */
   public Adapter createAbstractImplementationAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.Binding <em>Binding</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.Binding
    * @generated
    */
   public Adapter createBindingAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.Component <em>Component</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.Component
    * @generated
    */
   public Adapter createComponentAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.ComponentType <em>Component Type</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.ComponentType
    * @generated
    */
   public Adapter createComponentTypeAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.Composite <em>Composite</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.Composite
    * @generated
    */
   public Adapter createCompositeAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.EntryPoint <em>Entry Point</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.EntryPoint
    * @generated
    */
   public Adapter createEntryPointAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.ExternalService <em>External Service</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.ExternalService
    * @generated
    */
   public Adapter createExternalServiceAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.Implementation <em>Implementation</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.Implementation
    * @generated
    */
   public Adapter createImplementationAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.ImplementationComponent <em>Implementation Component</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.ImplementationComponent
    * @generated
    */
   public Adapter createImplementationComponentAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.Interface <em>Interface</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.Interface
    * @generated
    */
   public Adapter createInterfaceAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.JavaImplementation <em>Java Implementation</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.JavaImplementation
    * @generated
    */
   public Adapter createJavaImplementationAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.JavaInterface <em>Java Interface</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.JavaInterface
    * @generated
    */
   public Adapter createJavaInterfaceAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.Module <em>Module</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.Module
    * @generated
    */
   public Adapter createModuleAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.ModuleComponent <em>Module Component</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.ModuleComponent
    * @generated
    */
   public Adapter createModuleComponentAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.ModuleFragment <em>Module Fragment</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.ModuleFragment
    * @generated
    */
   public Adapter createModuleFragmentAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.ModuleReference <em>Module Reference</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.ModuleReference
    * @generated
    */
   public Adapter createModuleReferenceAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.ModuleService <em>Module Service</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.ModuleService
    * @generated
    */
   public Adapter createModuleServiceAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.ModuleWire <em>Module Wire</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.ModuleWire
    * @generated
    */
   public Adapter createModuleWireAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.Property <em>Property</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.Property
    * @generated
    */
   public Adapter createPropertyAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.PropertyValue <em>Property Value</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.PropertyValue
    * @generated
    */
   public Adapter createPropertyValueAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.PropertyValuesSet <em>Property Values Set</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.PropertyValuesSet
    * @generated
    */
   public Adapter createPropertyValuesSetAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.Reference <em>Reference</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.Reference
    * @generated
    */
   public Adapter createReferenceAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.ReferenceValue <em>Reference Value</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.ReferenceValue
    * @generated
    */
   public Adapter createReferenceValueAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.ReferenceValuesSet <em>Reference Values Set</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.ReferenceValuesSet
    * @generated
    */
   public Adapter createReferenceValuesSetAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.SCABinding <em>Binding</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.SCABinding
    * @generated
    */
   public Adapter createSCABindingAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.SCACoreRoot <em>Core Root</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.SCACoreRoot
    * @generated
    */
   public Adapter createSCACoreRootAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.Service <em>Service</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.Service
    * @generated
    */
   public Adapter createServiceAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.SLSBBinding <em>SLSB Binding</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.SLSBBinding
    * @generated
    */
   public Adapter createSLSBBindingAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.Subsystem <em>Subsystem</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.Subsystem
    * @generated
    */
   public Adapter createSubsystemAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.SystemWire <em>System Wire</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.SystemWire
    * @generated
    */
   public Adapter createSystemWireAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.UnknownImplementation <em>Unknown Implementation</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.UnknownImplementation
    * @generated
    */
   public Adapter createUnknownImplementationAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.WebServiceBinding <em>Web Service Binding</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.WebServiceBinding
    * @generated
    */
   public Adapter createWebServiceBindingAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.WSDLPortType <em>WSDL Port Type</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.WSDLPortType
    * @generated
    */
   public Adapter createWSDLPortTypeAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for the default case. <!-- begin-user-doc --> This
    * default implementation returns null. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @generated
    */
   public Adapter createEObjectAdapter() {
      return null;
   }

} // SCAAdapterFactory
