/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
/*
 * Created on May 23, 2005
 *
 * Copyright 2006 by IONA Technologies PLC, Inc.,
 *
 * All rights reserved.
 *
 */
package org.eclipse.stp.sc.jaxws.wizards;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.wizards.AbstractScWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;


/**
 * TODO Explain class purpose
 */
public class ScWizardDialog extends WizardDialog {
	private static final LoggingProxy LOG = LoggingProxy.getlogger(ScWizardDialog.class);
    boolean isMovingForward = true;

    public ScWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);

        // initialize starting page data
        try {
            AbstractScWizardPage startingCeltixPage;

            if (getWizard().getStartingPage() instanceof AbstractScWizardPage) {
                startingCeltixPage = (AbstractScWizardPage)getCurrentPage();
                startingCeltixPage.initializeFromData(startingCeltixPage.getWizardData());
                startingCeltixPage.updatePageState();
            }
        } catch (Exception e) {
            LOG.debug("data model handling failed", e);
        }

        return control;
    }

    public void showPage(IWizardPage page) {
        AbstractScWizardPage currentCeltixPage;

        try {
            // apply data from the old current page
            if (getCurrentPage() instanceof AbstractScWizardPage) {
                currentCeltixPage = (AbstractScWizardPage)getCurrentPage();
                currentCeltixPage.applyToData(currentCeltixPage.getWizardData());

                if (isMovingForward) {
                    page = getCurrentPage().getNextPage();
                }
            }

            // show the new page
            super.showPage(page);

            // set default focus on the page's top level control for infopop help
            page.getControl().forceFocus();

            // initialize new current page data
            if (getCurrentPage() instanceof AbstractScWizardPage) {
                currentCeltixPage = (AbstractScWizardPage)getCurrentPage();
                currentCeltixPage.initializeBeforeDisplay();
            }
        } catch (Exception e) {
            //TODO            LOG.debug("data model handling failed", e);
        }
    }

    protected void backPressed() {
        isMovingForward = false;
        super.backPressed();
    }

    protected void nextPressed() {
        isMovingForward = true;
        super.nextPressed();
    }

    protected void finishPressed() {
        // make sure current page has an opportunity to save current data
        AbstractScWizardPage currentCeltixPage;

        try {
            if (getCurrentPage() instanceof AbstractScWizardPage) {
                currentCeltixPage = (AbstractScWizardPage)getCurrentPage();
                currentCeltixPage.applyToData(currentCeltixPage.getWizardData());
            }
        } catch (Exception e) {
            //TODO            LOG.debug("finish handling failed", e);
        }

        super.finishPressed();
    }
}
