/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.editor;

import java.util.ArrayList;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.stp.xef.XMLInstanceElement;
import org.eclipse.ui.forms.IDetailsPage;
import org.jdom.Attribute;
import org.jdom.Element;


public class ChangePrefixAction extends Action {
	private final XefEditMasterDetailsBlock block;
    String nonInteractiveNewValue = null; // used for testing
	
	ChangePrefixAction(XefEditMasterDetailsBlock b) {
		super("Change Prefix");
		
		block = b;
	}

	@Override
	public void run() {
        XMLInstanceElement ie = block.getSelectedPolicyInstanceElement();
        if (ie == null) {
		return;
        }

        InputDialog dlg = new InputDialog(block.getViewer().getControl().getShell(), 
						"Change Prefix", "Please enter the new Name Space prefix to use", 
						ie.getNamespacePrefix(),
						new NameSpacePrefixInputValidator());
        
        String newNS = null;
        if (nonInteractiveNewValue != null) {
		newNS = nonInteractiveNewValue;
		nonInteractiveNewValue = null;
        } else {
		if (dlg.open() == Window.OK) {
			newNS = dlg.getValue();
		}
        }
        
		if (newNS != null) {
		changePrefix(newNS, ie);
        }
	}
	
	@SuppressWarnings("unchecked")
	void changePrefix(String newPrefix, XMLInstanceElement ie) {
        Element el = ie.getJDOMElement();
        Element newEl = new Element(el.getName(), newPrefix, el.getNamespaceURI());
        for (Attribute attr : new ArrayList<Attribute>(el.getAttributes())) {
		newEl.setAttribute(attr.detach());
        }
        newEl.addContent(el.cloneContent());
        ie.setJDOMElement(newEl);

        // refresh the way this label looks
        XefEditMasterDetailsBlock.policyLabels.put(ie, ie.toString());
        block.getViewer().refresh(ie);

        IDetailsPage details = block.getDetailsPart().getCurrentPage();
        if (details instanceof IXefDetailsPage) {
		((IXefDetailsPage) details).setDirty(true);
        }
	}
	
	static class NameSpacePrefixInputValidator implements IInputValidator {
		public String isValid(String newText) {
			if (newText.length() == 0) {
				return "The prefix cannot be empty";
			} else if (newText.matches("(.*)\\s(.*)")) {
				return "The name space prefix cannot contain spaces";
			} else if (newText.matches("(.*)[^a-z0-9](.*)")) {
				return "The name space prefix can only contain lowercase alphanumeric characters";
			}
			return null;
		}		
	}
}
