/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.editor;

import java.io.ByteArrayInputStream;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLEditPage extends TextEditor implements IFormPage, IGotoMarker {
    private final String title;
    private XefEditor editor;
    private final String id;
    private Control control;
    private int index;    

    public XMLEditPage(XefEditor editor, String id, String t) throws PartInitException {
        this.id = id;
        initialize(editor);
        init(editor.getEditorSite(), editor.getEditorInput());
        title = t;
    }

    public void initialize(FormEditor formEditor) {
        this.editor = (XefEditor) formEditor;
    }
        
    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        
        try {
		// davidb: this section here is a bit messy and could be improved. 
		// It solves the problem of making the editor dirty without actually
		// editing anything, simply by flicking to the XML page. 
		// This problem is caused by the fact that the widget edit page (potentially)
		// reformats the XML, which is picked up by the editor as a change in the text.
		// 
		// The code below preempt this by doing the same reformatting at the very
		// beginning. It might be a better idea to avoid reformatting altogether, but
		// this may be tricky to do.
			IDocument doc = getDocumentProvider().getDocument(editor.getEditorInput());
			SAXBuilder builder = new SAXBuilder();
			Document xmlDoc = builder.build(new ByteArrayInputStream(doc.get().getBytes()));
			doc.set(new XMLOutputter(Format.getPrettyFormat()).outputString(xmlDoc));
			doSave(new NullProgressMonitor());
		} catch (Exception e) {
			e.printStackTrace();
		}
        
        setPartName(title);
    }

    public FormEditor getEditor() {
        return editor;
    }

    public IManagedForm getManagedForm() {
        // not a form page
        return null;
    }

    public void setActive(boolean active) {
        if (active) {
            syncFromModel();
        }
    }

    void syncFromModel() {
        IDocument doc = getDocumentProvider().getDocument(editor.getEditorInput());
        String xml = editor.policyEditPage.getXML();
        if (!xml.equals(doc.get())) {
            try {
                doc.set(xml);
            } catch (RuntimeException re) {
                if (System.getProperty("test.mode") != null &&
                    re.getClass().getName().equals("org.eclipse.jface.text.Assert$AssertionFailedException")) {            
                    // for some strange reason doc.set() sometimes throws an AssertionFailedException out of
                    // org.eclipse.ui.internal.texteditor.quickdiff.compare.equivalence.DocEquivalenceComparator line 47
                    // but this only seems to happen on linux
                    re.printStackTrace();
                } else {
                    throw re;
                }
            }                
        }
    }

    public boolean isActive() {
        return this.equals(editor.getActivePageInstance());
    }

    public boolean canLeaveThePage() {
        return true;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control [] children = parent.getChildren();
        control = children[children.length - 1];
    }

    public Control getPartControl() {
        return control;
    }

    public String getId() {
        return id;
    }

    public int getIndex() {
        return index;
    }

    public void setIndex(int idx) {
        index = idx;
    }

    public boolean isEditor() {
        return true;
    }

    public boolean selectReveal(Object object) {
        if (object instanceof IMarker) {
            IDE.gotoMarker(this, (IMarker)object);
            return true;
        }
        return false;
    }

    @Override
    protected void firePropertyChange(int type) {
        if (type == PROP_DIRTY) {
            editor.fireSaveNeeded(getEditorInput(), true);
        } else {
            super.firePropertyChange(type);
        }
    }
}
