/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.help;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class XefHelpView extends ViewPart {
    private static final String INITIAL_HTML = 
        "<html><body><font size=\"-1\"><em>"
        + "Select a policy element or attribute in the policy editor."
        + "</em></font></body></html>";
    
    private String title = ""; 
    private Browser browser;

    @Override
    public void createPartControl(Composite parent) {
        browser = new Browser(parent, SWT.NONE);

        setHTMLText("", INITIAL_HTML);
    }

    @Override
    public void setFocus() {
        browser.setFocus();
    }
    
    public String getTitle() {
        return title;
    }
    
    public void setHTMLText(String titleHtml, String html) {
        if (titleHtml.equals(title)) {
            return;
        }

        title = titleHtml;
        System.out.println("Setting HTML " + System.currentTimeMillis());
        browser.setText(titleHtml + html);
        browser.getParent().layout(true);
    }
}
