/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.emf.editors;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/**
 * @author rcernich
 * 
 * Created on Mar 8, 2004
 */
public abstract class EMFSectionPart extends SectionPart {

	/**
	 * @param section
	 */
	public EMFSectionPart(Section section) {
		super(section);
	}

	/**
	 * @param parent
	 * @param toolkit
	 * @param style
	 */
	public EMFSectionPart(Composite parent, FormToolkit toolkit, int style) {
		super(parent, toolkit, style);
	}

	/**
	 * @return 
	 * @deprecated please use getResourceEditingContainer()
	 */
	public EMFFormEditor getEMFFormEditor() {
		EMFFormEditor editor;
		if (getManagedForm().getContainer() instanceof EMFFormPage) {
			editor = ((EMFFormPage) getManagedForm().getContainer())
					.getEMFFormEditor();
		}
		else {
			editor = null;
		}
		return editor;
	}

	public IResourceEditingContainer getResourceEditingContainer() {
		return (IResourceEditingContainer) getManagedForm().getContainer();
	}

	protected void fireSelectionChanged(ISelection selection) {
		getManagedForm().fireSelectionChanged(this, selection);
	}

	protected abstract void setModelRoot(EObject modelRoot);
}