/*******************************************************************************
 * Copyright (c) 2003-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.dialogs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

/**
 * Extend this class with your dialog page implementation.  Call
 * setNeedsApplyButton() in your constructor.  Use the setIsValid(),
 * setIsModified(), setTitle(), setDescription(), setMessage(), and
 * setErrorMessage() to control aspects of the dialog.  These methods also force
 * the update of the widgets they apply to.
 *  
 * @author rcernich
 */
public abstract class DialogPage
	extends org.eclipse.jface.dialogs.DialogPage
	implements IDialogPage {

	private IDialogPageContainer mContainer;
	private boolean mIsValid = true;
	private boolean mIsModified = false;
	private boolean mNeedsApply = true;

	/**
	 * Constructor for BPDialogPage.
	 */
	public DialogPage() {
		super();
	}

	/**
	 * Constructor for BPDialogPage.
	 * @param title
	 */
	public DialogPage(String title) {
		super(title);
	}

	/**
	 * Constructor for BPDialogPage.
	 * @param title
	 * @param image
	 */
	public DialogPage(String title, ImageDescriptor image) {
		super(title, image);
	}

	public boolean needsApplyButton()
	{
		return mNeedsApply;
	}

	public void setNeedsApplyButton(boolean needsApply)
	{
		mNeedsApply = needsApply;
	}

	public void setIsValid(boolean isValid) {
		mIsValid = isValid;
		if (getContainer() != null) {
			getContainer().updateButtons();
		}
	}

	public void setIsModified(boolean isModified) {
		mIsModified = isModified;
		if (getContainer() != null) {
			getContainer().updateButtons();
		}
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(Composite)
	 */
	public abstract void createControl(Composite parent);


	public boolean isValid() {
		return mIsValid;
	}

	public boolean isModified() {
		return mIsModified;
	}


	public abstract boolean performOk();


	public boolean performApply() {
		boolean success = performOk();
		if (success) {
			setIsModified(false);
		}
		return success;
	}

	public boolean performCancel() {
		return true;
	}


	public IDialogPageContainer getContainer() {
		return mContainer;
	}

	public void setContainer(IDialogPageContainer container) {
		mContainer = container;
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#setDescription(String)
	 */
	public void setDescription(String description) {
		super.setDescription(description);
		if (getContainer() != null) {
			getContainer().updateTitleBar();
		}
	}

	/**
	 * @see org.eclipse.jface.dialogs.DialogPage#setErrorMessage(String)
	 */
	public void setErrorMessage(String newMessage) {
		super.setErrorMessage(newMessage);
		if (getContainer() != null) {
			getContainer().updateMessage();
		}
	}

	/**
	 * @see org.eclipse.jface.dialogs.DialogPage#setMessage(String, int)
	 */
	public void setMessage(String newMessage, int newType) {
		super.setMessage(newMessage, newType);
		if (getContainer() != null) {
			getContainer().updateMessage();
		}
	}

	/**
	 * @see org.eclipse.jface.dialogs.DialogPage#setMessage(String)
	 */
	public void setMessage(String newMessage) {
		super.setMessage(newMessage);
		if (getContainer() != null) {
			getContainer().updateMessage();
		}
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#setTitle(String)
	 */
	public void setTitle(String title) {
		super.setTitle(title);
		if (getContainer() != null) {
			getContainer().updateTitleBar();
		}
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#setImageDescriptor(ImageDescriptor)
	 */
	public void setImageDescriptor(ImageDescriptor image) {
		//  ICON REVIEW:  No title images on dialogs
		//super.setImageDescriptor(image);
		//if (getContainer() != null) {
		//	getContainer().updateTitleBar();
		//}
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#getImage()
	 */
	public Image getImage() {
		Image image = super.getImage();
		if (image == null) {
			// Return a 48x48 image so the description area is the right size.
			image = new Image(Display.getCurrent(),48,48);
		}
		return image;
	}

}
