/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.stp.soas.internal.deploy.ui.AbstractUIPluginBase;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.forms.FormColors;

/**
 * The main plugin class to be used in the desktop.
 */
public class DeployCorePlugin extends AbstractUIPluginBase implements
		IStartup {

	//The shared instance.
	private static DeployCorePlugin plugin;
	private FormColors mFormColors;

	/**
	 * The constructor.
	 */
	public DeployCorePlugin() {
		super();
		plugin = this;
	}

	/**
	 * Returns the shared instance.
	 */
	public static DeployCorePlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.ui.AbstractUIPluginBase#loadResourceBundle()
	 */
	public ResourceBundle loadResourceBundle() throws MissingResourceException {
		return ResourceBundle
				.getBundle(getClass().getPackage().getName()+".PluginResources"); //$NON-NLS-1$
	}

	public FormColors getFormColors(Display display) {
		if (mFormColors == null) {
			mFormColors = new FormColors(display);
			mFormColors.markShared();
		}
		return mFormColors;
	}

	/**
	 * TODO: Used only for development debug. Should be removed from production
	 * code.
	 * 
	 * @see org.eclipse.ui.IStartup#earlyStartup()
	 */
	public void earlyStartup() {
		if (isDebugging()) {
			// Force parsing of the deployment extensions
			DeploymentExtensionManager.getInstance();
		}
	}
}