/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.stp.soas.deploy.core.utils.DeploymentUtil;


/**
 * @author shongxum
 */
public class Version implements IVersion {

	private int major;
	private int minor;
	private int release;
	private String build;
	
	public Version(int major, int minor, int release, String build) {
		this.major = major;
		this.minor = minor;
		this.release = release;
		this.build = build;
	}
 
	public static final Version NULL_VERSION = new Version(0,0,0,"");
	
	
	public static Version valueOf(String version) {
		int maj = 0;
		int min = 0;
		try {
			if (version.length() > 1 && version.indexOf(".") >= 0) {
				min = Integer.valueOf(version
						.substring(version.indexOf(".") + 1));
				maj = Integer.valueOf(version
						.substring(0, version.indexOf(".")));
			} 
			else if (Integer.valueOf(version) != null) {
				return new Version(Integer.valueOf(version), min, 0, "");
			}
		} catch (Exception ex) {
			return NULL_VERSION;
		}

		return new Version(maj, min, 0, "");

	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.datatools.connectivity.IVersion#getMajor()
	 */
	public int getMajor() {
		return major;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.datatools.connectivity.IVersion#getMinor()
	 */
	public int getMinor() {
		return minor;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.datatools.connectivity.IVersion#getRelease()
	 */
	public int getRelease() {
		return release;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.datatools.connectivity.IVersion#getBuild()
	 */
	public String getBuild() {
		return build;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
		return this.toString().compareTo(((Version) o).toString());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		boolean retVal;
		if (obj instanceof Version) {
			retVal = compareTo(obj) == 0;
		}
		else {
			retVal = false;
		}
		return retVal;
	}

	public boolean isCompatibleWithVersion(IVersion actual, MatchRule matchRule) {
		boolean retVal;
		if (matchRule == MatchRule.PERFECT) {
			retVal = comparePerfect(actual);
		}
		else if (matchRule == MatchRule.EQUIVALENT) {
			retVal = compareEquivalent(actual);
		}
		else if (matchRule == MatchRule.COMPATIBLE) {
			retVal = compareCompatible(actual);
		}
		else if (matchRule == MatchRule.EQUAL_OR_GREATER) {
			retVal = compareEqualOrGreater(actual);
		}
		else {
			throw new IllegalArgumentException();
		}
		return retVal;
	}

	

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		if(build == null || "".equals(build)){
			return major + "." + minor + "." + release;
		}
		else{
			return major + "." + minor + "." + release + "." + build;
		}
		
	}

	private boolean comparePerfect(IVersion actual) {
		return getMajor() == actual.getMajor()
				&& getMinor() == actual.getMinor()
				&& getRelease() == actual.getRelease()
				&& getBuild().compareTo(actual.getBuild()) == 0;
	}

	private boolean compareEquivalent(IVersion actual) {
		boolean retVal;
		if (getMajor() == actual.getMajor()) {
			if (getMinor() == actual.getMinor()) {
				if (getRelease() == actual.getRelease()) {
					retVal = getBuild().compareTo(actual.getBuild()) <= 0;
				}
				else {
					retVal = getRelease() < actual.getRelease();
				}
			}
			else {
				retVal = false;
			}
		}
		else {
			retVal = false;
		}
		return retVal;
	}

	private boolean compareCompatible(IVersion actual) {
		boolean retVal;
		if (getMajor() == actual.getMajor()) {
			if (getMinor() == actual.getMinor()) {
				if (getRelease() == actual.getRelease()) {
					retVal = getBuild().compareTo(actual.getBuild()) <= 0;
				}
				else {
					retVal = getRelease() < actual.getRelease();
				}
			}
			else {
				retVal = getMinor() < actual.getMinor();
			}
		}
		else {
			retVal = false;
		}
		return retVal;
	}

	private boolean compareEqualOrGreater(IVersion actual) {
		boolean retVal;
		if (getMajor() == actual.getMajor()) {
			if (getMinor() == actual.getMinor()) {
				if (getRelease() == actual.getRelease()) {
					retVal = getBuild().compareTo(actual.getBuild()) <= 0;
				}
				else {
					retVal = getRelease() < actual.getRelease();
				}
			}
			else {
				retVal = getMinor() < actual.getMinor();
			}
		}
		else {
			retVal = getMajor() < actual.getMajor();
		}
		return retVal;
	}

}