/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.ILogicalPackageExtension;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.ISupportedRuntimeType;
import org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType;
import org.eclipse.stp.soas.deploy.core.ITechnologyType;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.wst.server.core.IRuntimeType;


/**
 * @author rcernich
 * 
 * Created on Mar 18, 2004
 */
public class LogicalPackageExtension extends PackageExtension implements
		ILogicalPackageExtension {

	public static final String ATTR_CLASS = "class"; //$NON-NLS-1$

	private ISupportedTechnologyType mSupportedTechnology;
	
	private ISupportedRuntimeType mSupportedRuntime;

	public LogicalPackageExtension(IConfigurationElement element)
			throws PackageExtensionException {
		super(element);
		init();
	}

	public ISupportedTechnologyType getSupportedTechnologyType() {
		return mSupportedTechnology;
	}

	public boolean supportsTechnology(ITechnologyType type) {
		return mSupportedTechnology.supportsTechnology(type);
	}

	public IPackage adaptFile(IFile file) {
		ILogicalPackage ilp;
		try {
			ilp = (ILogicalPackage) getConfigurationElement()
					.createExecutableExtension(ATTR_CLASS);
			ilp.init(this, file);
		}
		catch (CoreException e) {
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.err
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"LogicalPackageExtension.trace.error.logicalPackageClassNotFound", //$NON-NLS-1$
										new Object[] {
												getID(),
												getConfigurationElement()
														.getAttribute(
																ATTR_CLASS),
												file.getFullPath().toString()}));
				System.err.flush();
			}
			ilp = null;
		}
		return ilp;
	}

	private void init() throws PackageExtensionException {
		processSupportedTechnologyElement();
		processSupportedRuntimeElement();
	}

	private void processSupportedTechnologyElement()
			throws PackageExtensionException {
		IConfigurationElement[] supportedTechnologies = getConfigurationElement()
				.getChildren(
						DeploymentExtensionManager.EXT_ELEM_SUPPORTED_TECHNOLOGY);

		if (supportedTechnologies.length < 1) {
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.err
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"LogicalPackageExtension.trace.error.supportedTechnologyNotSpecified", //$NON-NLS-1$
										new Object[] { getID()}));
				System.err.flush();
			}
			throw new PackageExtensionException(
					DeployCorePlugin
							.getDefault()
							.getResourceString(
									"LogicalPackageExtension.exception.supportedTechnologyNotSpecified")); //$NON-NLS-1$
		}
		else if (supportedTechnologies.length > 1) {
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.err
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"LogicalPackageExtension.trace.error.multipleSupportedTechnologyElements", //$NON-NLS-1$
										new Object[] { getID()}));
				System.err.flush();
			}
			throw new PackageExtensionException(
					DeployCorePlugin
							.getDefault()
							.getResourceString(
									"LogicalPackageExtension.exception.multipleSupportedTechnologyElements")); //$NON-NLS-1$
		}

		mSupportedTechnology = new SupportedTechnologyType(
				supportedTechnologies[0]);
	}

	private void processSupportedRuntimeElement()
			throws PackageExtensionException {
		IConfigurationElement[] supportedRuntimes = getConfigurationElement()
				.getChildren(
						DeploymentExtensionManager.EXT_ELEM_SUPPORTED_RUNTIME);

		if (supportedRuntimes.length < 1) {
			//for logical package, the supported runtime is optional. 
			//if the runtime is not assigned, that means this package can run on any runtime if 
			//it supports the specified technology type.
			return;
			/*
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.err
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"LogicalPackageExtension.trace.error.supportedTechnologyNotSpecified", //$NON-NLS-1$
										new Object[] { getID() }));
				System.err.flush();
			}
			throw new PackageExtensionException(
					DeployCorePlugin
							.getDefault()
							.getResourceString(
									"LogicalPackageExtension.exception.supportedTechnologyNotSpecified")); //$NON-NLS-1$
									*/
		} else if (supportedRuntimes.length > 1) {
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.err
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"LogicalPackageExtension.trace.error.multipleSupportedTechnologyElements", //$NON-NLS-1$
										new Object[] { getID() }));
				System.err.flush();
			}
			throw new PackageExtensionException(
					DeployCorePlugin
							.getDefault()
							.getResourceString(
									"LogicalPackageExtension.exception.multipleSupportedTechnologyElements")); //$NON-NLS-1$
		}

		mSupportedRuntime = new SupportedRuntimeType(
				supportedRuntimes[0]);
	}
	public ISupportedRuntimeType getSupportedRuntimeType() {

		return mSupportedRuntime;
	}

	public boolean supportsRuntime(IRuntimeType type) {
		// TODO Auto-generated method stub
		return false;
	}

}