/*
 * Decompiled with CFR 0.152.
 */
package org.eclipes.stp.soas.deploy.runtime.tuscany.core.internal;

import org.eclipes.stp.soas.deploy.runtime.tuscany.TuscanyRuntimePlugin;
import org.eclipes.stp.soas.deploy.runtime.tuscany.TuscanyRuntimeResources;
import org.eclipes.stp.soas.deploy.runtime.tuscany.core.internal.ITuscanyRuntime;
import org.eclipes.stp.soas.deploy.runtime.tuscany.core.internal.ITuscanyRuntimeWorkingCopy;
import org.eclipes.stp.soas.deploy.runtime.tuscany.core.internal.ITuscanyVersionHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public class TuscanyRuntime
extends RuntimeDelegate
implements ITuscanyRuntime,
ITuscanyRuntimeWorkingCopy {
    protected static final String PROP_VM_INSTALL_TYPE_ID = "vm-install-type-id";
    protected static final String PROP_VM_INSTALL_ID = "vm-install-id";

    public ITuscanyVersionHandler getVersionHandler() {
        IRuntimeType type = this.getRuntime().getRuntimeType();
        return TuscanyRuntimePlugin.getVersionHandler(type.getId());
    }

    public IVMInstall getVMInstall() {
        if (this.getVMInstallTypeId() == null) {
            return JavaRuntime.getDefaultVMInstall();
        }
        try {
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)this.getVMInstallTypeId());
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            int size = vmInstalls.length;
            String id = this.getVMInstallId();
            int i = 0;
            while (i < size) {
                if (id.equals(vmInstalls[i].getId())) {
                    return vmInstalls[i];
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void setVMInstall(IVMInstall vmInstall) {
        if (vmInstall == null) {
            this.setVMInstall(null, null);
        } else {
            this.setVMInstall(vmInstall.getVMInstallType().getId(), vmInstall.getId());
        }
    }

    public boolean verifyLocation() {
        return this.getVersionHandler().verifyInstallPath(this.getRuntime().getLocation());
    }

    public IStatus validate() {
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        if (!this.verifyLocation()) {
            return new Status(4, "org.eclipse.stp.soas.deploy.runtime.tuscanyjava", 0, TuscanyRuntimeResources.getString("wizard.errorInstallDir"), null);
        }
        return Status.OK_STATUS;
    }

    protected void setVMInstall(String typeId, String id) {
        if (typeId == null) {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, typeId);
        }
        if (id == null) {
            this.setAttribute(PROP_VM_INSTALL_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_ID, id);
        }
    }

    public boolean isUsingDefaultJRE() {
        return this.getVMInstallTypeId() == null;
    }

    protected String getVMInstallTypeId() {
        return this.getAttribute(PROP_VM_INSTALL_TYPE_ID, null);
    }

    protected String getVMInstallId() {
        return this.getAttribute(PROP_VM_INSTALL_ID, null);
    }
}

