/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stp.ui.xef.editor.SchemaSelectionDialog;
import org.eclipse.stp.ui.xef.editor.SelectionCategory;
import org.eclipse.stp.ui.xef.editor.XMLProviderEditorInput;
import org.eclipse.stp.ui.xef.editor.XefEditMasterDetailsBlock;
import org.eclipse.stp.ui.xef.editor.XefEditor;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.ui.xef.schema.SchemaRegistry;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.IXMLProvider;
import org.eclipse.stp.xef.URLSchemaProvider;
import org.eclipse.stp.xef.XMLInstanceElement;
import org.eclipse.stp.xef.XMLModelFactory;
import org.eclipse.stp.xef.XMLSnippet;
import org.eclipse.stp.xef.util.InputStreamHelper;
import org.eclipse.stp.xef.util.TestProject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class CombinedEditorAndSchemaDialogTest
extends TestCase {
    private TestProject testProject;

    protected synchronized void setUp() throws Exception {
        this.testProject = new TestProject();
        XMLModelFactory.interactive = false;
    }

    protected synchronized void tearDown() throws Exception {
        try {
            this.getPage().closeAllEditors(false);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        SchemaRegistry.getDefault().clear();
        this.testProject.dispose();
        XMLModelFactory.interactive = true;
    }

    private IWorkbenchPage getPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window.getActivePage();
    }

    public static void processUIEvents(Display display) {
        while (display.readAndDispatch()) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
    }

    public void testSelectPolicyThroughDialog() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test.policy"));
        file.create((InputStream)new ByteArrayInputStream("<policy/>".getBytes()), true, null);
        URLSchemaProvider urlSchemaProvider = new URLSchemaProvider(new URL[]{((Object)((Object)this)).getClass().getClassLoader().getResource("example_test_audit.xsd")});
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policy"), (ISchemaProvider)urlSchemaProvider, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        final XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        final StringBuffer exceptionText = new StringBuffer();
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                final SchemaSelectionDialog dialog = block.addButtonListener.currentDialog;
                dialog.getShell().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        try {
                            CombinedEditorAndSchemaDialogTest.processUIEvents(dialog.getShell().getDisplay());
                            CombinedEditorAndSchemaDialogTest.assertTrue((boolean)dialog.getShell().isVisible());
                            dialog.getTreeViewer().expandAll();
                            SelectionCategory firstCat = (SelectionCategory)dialog.categories.get("Uncategorized");
                            SchemaElement firstPolicy = (SchemaElement)firstCat.getEntries().iterator().next();
                            CombinedEditorAndSchemaDialogTest.assertEquals((String)"audit", (String)firstPolicy.getName());
                            StructuredSelection sel = new StructuredSelection((Object)firstPolicy);
                            CombinedEditorAndSchemaDialogTest.assertFalse((boolean)dialog.getOkButton().getEnabled());
                            dialog.getTreeViewer().setSelection((ISelection)sel, true);
                            CombinedEditorAndSchemaDialogTest.assertTrue((boolean)dialog.getOkButton().getEnabled());
                            CombinedEditorAndSchemaDialogTest.assertSame((Object)firstPolicy, (Object)dialog.getFirstResult());
                            dialog.getOkButton().setSelection(true);
                            dialog.getOkButton().notifyListeners(13, new Event());
                        }
                        catch (Throwable th) {
                            exceptionText.append("Exception caught: " + th);
                            th.printStackTrace();
                        }
                    }
                });
            }
        }, "Dialog controller thread");
        t.start();
        try {
            block.addButton.setSelection(true);
            block.addButton.notifyListeners(13, new Event());
        }
        catch (RuntimeException runtimeException) {}
        t.join();
        CombinedEditorAndSchemaDialogTest.processUIEvents(block.getViewer().getControl().getShell().getDisplay());
        CombinedEditorAndSchemaDialogTest.assertEquals((String)"The test thread has caused an exception", (String)"", (String)exceptionText.toString());
        CombinedEditorAndSchemaDialogTest.assertNull((Object)block.addButtonListener.currentDialog.getShell());
        CombinedEditorAndSchemaDialogTest.processUIEvents(block.getViewer().getControl().getShell().getDisplay());
        IStructuredSelection sel2 = (IStructuredSelection)block.getViewer().getSelection();
        XMLInstanceElement auditPI = (XMLInstanceElement)sel2.getFirstElement();
        CombinedEditorAndSchemaDialogTest.assertNotNull((Object)auditPI);
        CombinedEditorAndSchemaDialogTest.assertEquals((String)"audit", (String)auditPI.getTemplate().getName());
    }

    public void testSelectSnippetThroughDialog() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test69.policy"));
        file.create((InputStream)new ByteArrayInputStream("<policy/>".getBytes()), true, null);
        XMLSnippet se = new XMLSnippet("Top Snippet", "<example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\" system_health_sample_interval=\"123\"/><example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\" system_health_sample_interval=\"999\"/>");
        URLSchemaProvider urlSchemaProvider = new URLSchemaProvider(new URL[]{((Object)((Object)this)).getClass().getClassLoader().getResource("example_test_audit.xsd")}, new XMLSnippet[]{se});
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policy"), (ISchemaProvider)urlSchemaProvider, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        final XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        final StringBuffer exceptionText = new StringBuffer();
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                final SchemaSelectionDialog dialog = block.addButtonListener.currentDialog;
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        try {
                            CombinedEditorAndSchemaDialogTest.processUIEvents(dialog.getShell().getDisplay());
                            CombinedEditorAndSchemaDialogTest.assertTrue((boolean)dialog.getShell().isVisible());
                            dialog.getTreeViewer().expandAll();
                            SelectionCategory firstCat = (SelectionCategory)dialog.categories.get("Composite Policies");
                            XMLSnippet firstSnippet = (XMLSnippet)firstCat.getEntries().iterator().next();
                            CombinedEditorAndSchemaDialogTest.assertEquals((String)"Top Snippet", (String)firstSnippet.getName());
                            StructuredSelection sel = new StructuredSelection((Object)firstSnippet);
                            CombinedEditorAndSchemaDialogTest.assertFalse((boolean)dialog.getOkButton().getEnabled());
                            dialog.getTreeViewer().setSelection((ISelection)sel, true);
                            CombinedEditorAndSchemaDialogTest.assertTrue((boolean)dialog.getOkButton().getEnabled());
                            CombinedEditorAndSchemaDialogTest.assertSame((Object)firstSnippet, (Object)dialog.getFirstResult());
                            dialog.getOkButton().setSelection(true);
                            dialog.getOkButton().notifyListeners(13, new Event());
                        }
                        catch (Throwable th) {
                            exceptionText.append("Exception caught: " + th);
                            th.printStackTrace();
                        }
                    }
                });
            }
        }, "Dialog controller thread");
        t.start();
        block.addButton.setSelection(true);
        block.addButton.notifyListeners(13, new Event());
        t.join();
        CombinedEditorAndSchemaDialogTest.assertEquals((String)"The test thread has caused an exception", (String)"", (String)exceptionText.toString());
        CombinedEditorAndSchemaDialogTest.assertNull((Object)block.addButtonListener.currentDialog.getShell());
        CombinedEditorAndSchemaDialogTest.assertTrue((String)"The editor should now be dirty", (boolean)editor.isDirty());
        TreeViewer viewer = block.getViewer();
        viewer.expandAll();
        TreeItem[] topItems = viewer.getTree().getItems();
        CombinedEditorAndSchemaDialogTest.assertEquals((int)1, (int)topItems.length);
        CombinedEditorAndSchemaDialogTest.assertEquals((String)"Top Snippet", (String)topItems[0].getText());
        TreeItem[] subItems = topItems[0].getItems();
        CombinedEditorAndSchemaDialogTest.assertEquals((int)2, (int)subItems.length);
        XMLInstanceElement auditPI0 = (XMLInstanceElement)subItems[0].getData();
        CombinedEditorAndSchemaDialogTest.assertEquals((String)"audit", (String)auditPI0.getTemplate().getName());
        CombinedEditorAndSchemaDialogTest.assertEquals((String)"123", (String)auditPI0.getAttribute("system_health_sample_interval"));
        XMLInstanceElement auditPI = (XMLInstanceElement)subItems[1].getData();
        CombinedEditorAndSchemaDialogTest.assertEquals((String)"audit", (String)auditPI.getTemplate().getName());
        CombinedEditorAndSchemaDialogTest.assertEquals((String)"999", (String)auditPI.getAttribute("system_health_sample_interval"));
    }

    private static class XMLFileXMLProvider
    implements IXMLProvider {
        private final IFile file;
        private final String root;

        public XMLFileXMLProvider(IFile f, String rootQName) {
            this.file = f;
            this.root = rootQName;
        }

        public String getRootElementQName() {
            return this.root;
        }

        public String getXML() {
            block6: {
                String string;
                InputStream is = this.file.getContents();
                try {
                    string = new String(InputStreamHelper.drain((InputStream)is));
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        break block6;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                is.close();
                return string;
            }
            return null;
        }

        public void setXML(String xml) {
            try {
                this.file.setContents((InputStream)new ByteArrayInputStream(xml.getBytes()), true, false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

