/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import junit.framework.TestCase;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stp.ui.xef.editor.SchemaSelectionDialog;
import org.eclipse.stp.ui.xef.editor.SelectionCategory;
import org.eclipse.stp.ui.xef.editor.ShadowEntry;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.ui.xef.schema.SchemaRegistry;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.IShadowProvider;
import org.eclipse.stp.xef.SchemaProviderFilterWrapper;
import org.eclipse.stp.xef.XMLInstanceElement;
import org.eclipse.stp.xef.XMLSnippet;
import org.eclipse.stp.xef.util.InputStreamHelper;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class SchemaDialogTest
extends TestCase {
    SchemaSelectionDialog dialog;
    SchemaProviderHolder schemaProviderHolder;

    protected void setUp() throws Exception {
        this.schemaProviderHolder = new SchemaProviderHolder();
        this.dialog = new SchemaSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ISchemaProvider)this.schemaProviderHolder, new IShadowProvider[0]);
        this.dialog.setBlockOnOpen(false);
    }

    protected void tearDown() throws Exception {
        this.dialog.close();
    }

    public void testSelectPolicy() throws Exception {
        TestSchemaProvider sp = new TestSchemaProvider();
        sp.schemas.put("http://www.example.com/xsd/2006/02/logging", SchemaDialogTest.loadSchema("example_test_logging.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2006/02/routing", SchemaDialogTest.loadSchema("example_test.xsd"));
        this.schemaProviderHolder.setProvider(sp);
        this.dialog.open();
        this.dialog.getTreeViewer().expandAll();
        SelectionCategory firstCat = (SelectionCategory)this.dialog.categories.get("Uncategorized");
        SchemaElement firstPolicy = (SchemaElement)firstCat.getEntries().iterator().next();
        StructuredSelection sel = new StructuredSelection((Object)firstPolicy);
        SchemaDialogTest.assertFalse((boolean)this.dialog.getOkButton().getEnabled());
        this.dialog.getTreeViewer().setSelection((ISelection)sel, true);
        SchemaDialogTest.assertTrue((boolean)this.dialog.getOkButton().getEnabled());
        SchemaDialogTest.assertSame((Object)firstPolicy, (Object)this.dialog.getFirstResult());
    }

    public void testSelectSnippet() throws Exception {
        TestSchemaProvider sp = new TestSchemaProvider();
        sp.schemas.put("http://www.example.com/xsd/2006/02/test_audit", SchemaDialogTest.loadSchema("example_test_audit.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2006/02/test_reliable", SchemaDialogTest.loadSchema("example_test_reliable.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2006/02/test", SchemaDialogTest.loadSchema("example_test.xsd"));
        String relSnippet = "<example:Reliable xmlns:example=\"http://www.example.com/xsd/2006/02/test_reliable\"/>";
        sp.snippets.put("Simple Reliable", relSnippet);
        this.schemaProviderHolder.setProvider(sp);
        this.dialog.open();
        this.dialog.getTreeViewer().expandAll();
        SelectionCategory snippetCat = (SelectionCategory)this.dialog.categories.get("Composite Policies");
        XMLSnippet firstSnippet = (XMLSnippet)snippetCat.getEntries().iterator().next();
        SchemaDialogTest.assertEquals((String)relSnippet, (String)firstSnippet.getSnippet());
        SchemaDialogTest.assertFalse((boolean)this.dialog.getOkButton().getEnabled());
        this.dialog.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)firstSnippet));
        SchemaDialogTest.assertTrue((boolean)this.dialog.getOkButton().getEnabled());
        SchemaDialogTest.assertSame((Object)firstSnippet, (Object)this.dialog.getFirstResult());
    }

    public void testSorting() throws Exception {
        TestSchemaProvider sp = new TestSchemaProvider();
        sp.schemas.put("http://www.example.com/xsd/2006/02/test_reliable", SchemaDialogTest.loadSchema("example_test_reliable.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2006/02/test", SchemaDialogTest.loadSchema("example_test.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2006/02/test_audit", SchemaDialogTest.loadSchema("example_test_audit.xsd"));
        String relSnippet = "<example:Reliable xmlns:example=\"http://www.example.com/xsd/2006/02/test_reliable\"/>";
        sp.snippets.put("Simple Reliable", relSnippet);
        sp.snippets.put("Another Snippet", relSnippet);
        this.schemaProviderHolder.setProvider(sp);
        this.dialog.open();
        this.dialog.getTreeViewer().expandAll();
        SelectionCategory otherCat = (SelectionCategory)this.dialog.categories.get("Uncategorized");
        ArrayList schemas = new ArrayList(otherCat.getEntries());
        SchemaDialogTest.assertEquals((String)"audit", (String)((SchemaElement)schemas.get(0)).getName());
        SchemaDialogTest.assertEquals((String)"Reliable", (String)((SchemaElement)schemas.get(1)).getName());
        SchemaDialogTest.assertEquals((String)"Routing", (String)((SchemaElement)schemas.get(2)).getName());
        SelectionCategory snippetCat = (SelectionCategory)this.dialog.categories.get("Composite Policies");
        ArrayList snippets = new ArrayList(snippetCat.getEntries());
        SchemaDialogTest.assertEquals((String)"Another Snippet", (String)((XMLSnippet)snippets.get(0)).getName());
        SchemaDialogTest.assertEquals((String)"Simple Reliable", (String)((XMLSnippet)snippets.get(1)).getName());
    }

    public void testRefresh() throws Exception {
        TestSchemaProvider sp = new TestSchemaProvider(){

            public void refresh() {
                this.schemas.clear();
                try {
                    this.schemas.put("http://www.example.com/xsd/2006/02/test_audit", SchemaDialogTest.loadSchema("example_test_audit.xsd"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        sp.schemas.put("http://www.example.com/xsd/2006/02/test_reliable", SchemaDialogTest.loadSchema("example_test_reliable.xsd"));
        this.schemaProviderHolder.setProvider(sp);
        this.dialog.open();
        this.dialog.getTreeViewer().expandAll();
        SelectionCategory otherCat = (SelectionCategory)this.dialog.categories.get("Uncategorized");
        SortedSet schemas = otherCat.getEntries();
        SchemaDialogTest.assertEquals((int)1, (int)schemas.size());
        SchemaDialogTest.assertEquals((String)"Reliable", (String)((SchemaElement)schemas.iterator().next()).getName());
        ToolItem ti = (ToolItem)this.getWidget((Composite)this.dialog.getShell(), ToolItem.class, "getToolTipText", "Refresh");
        ti.setSelection(true);
        ti.notifyListeners(13, new Event());
        this.dialog.getTreeViewer().expandAll();
        SelectionCategory otherCat2 = (SelectionCategory)this.dialog.categories.get("Uncategorized");
        SortedSet schemas2 = otherCat2.getEntries();
        SchemaDialogTest.assertEquals((int)1, (int)schemas2.size());
        SchemaDialogTest.assertEquals((String)"audit", (String)((SchemaElement)schemas2.iterator().next()).getName());
    }

    public void testRefreshContent() throws Exception {
        TestSchemaProvider sp = new TestSchemaProvider(){

            public void refresh() {
                this.schemas.clear();
                try {
                    this.schemas.put("http://www.example.com/xsd/2006/02/test_audit", SchemaDialogTest.loadSchema("example_test_audit_modified.xsd"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        sp.schemas.put("http://www.example.com/xsd/2006/02/test_audit", SchemaDialogTest.loadSchema("example_test_audit.xsd"));
        this.schemaProviderHolder.setProvider(sp);
        this.dialog.open();
        this.dialog.getTreeViewer().expandAll();
        SelectionCategory otherCat = (SelectionCategory)this.dialog.categories.get("Uncategorized");
        SortedSet schemas = otherCat.getEntries();
        SchemaDialogTest.assertEquals((int)1, (int)schemas.size());
        SchemaDialogTest.assertEquals((String)"example:audit", (String)((SchemaElement)schemas.iterator().next()).getDisplayName());
        ToolItem ti = (ToolItem)this.getWidget((Composite)this.dialog.getShell(), ToolItem.class, "getToolTipText", "Refresh");
        ti.setSelection(true);
        ti.notifyListeners(13, new Event());
        this.dialog.getTreeViewer().expandAll();
        SelectionCategory otherCat2 = (SelectionCategory)this.dialog.categories.get("Uncategorized");
        SortedSet schemas2 = otherCat2.getEntries();
        SchemaDialogTest.assertEquals((int)1, (int)schemas2.size());
        SchemaDialogTest.assertEquals((String)"Audit Policy", (String)((SchemaElement)schemas2.iterator().next()).getDisplayName());
    }

    public void testLazySnippetLoading() throws Exception {
        TestSchemaProvider sp = new TestSchemaProvider();
        sp.schemas.put("http://www.example.com/xsd/2006/02/test_reliable", SchemaDialogTest.loadSchema("example_test_reliable.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2006/02/test", SchemaDialogTest.loadSchema("example_test.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2006/02/test_audit", SchemaDialogTest.loadSchema("example_test_audit.xsd"));
        String relSnippet = "<example:Reliable xmlns:example=\"http://www.example.com/xsd/2006/02/test_reliable\"/>";
        sp.snippets.put("Simple Reliable", relSnippet);
        sp.snippets.put("Another Snippet", relSnippet);
        TestSchemaProviderDecorator spd = new TestSchemaProviderDecorator(sp);
        this.schemaProviderHolder.setProvider(spd);
        this.dialog.open();
        SchemaDialogTest.assertFalse((String)"listSnippets() called too early", (boolean)spd.listSnippetsCalled);
        this.dialog.getTreeViewer().expandAll();
        SchemaDialogTest.assertTrue((String)"listSnippets() must now have been called", (boolean)spd.listSnippetsCalled);
        SelectionCategory snippetCat = (SelectionCategory)this.dialog.categories.get("Composite Policies");
        SchemaDialogTest.assertEquals((int)2, (int)snippetCat.getEntries().size());
        sp.snippets.put("A third snippet", relSnippet);
        SelectionCategory snippetCat2 = (SelectionCategory)this.dialog.categories.get("Composite Policies");
        SchemaDialogTest.assertEquals((String)"We haven't refreshed yet, so still 2 snippets", (int)2, (int)snippetCat2.getEntries().size());
        ToolItem ti = (ToolItem)this.getWidget((Composite)this.dialog.getShell(), ToolItem.class, "getToolTipText", "Refresh");
        ti.setSelection(true);
        ti.notifyListeners(13, new Event());
        SelectionCategory snippetCat3 = (SelectionCategory)this.dialog.categories.get("Composite Policies");
        SchemaDialogTest.assertEquals((String)"Should have 0 snippets now, after the refresh call but before the lazy loading", (int)0, (int)snippetCat3.getEntries().size());
        this.dialog.getTreeViewer().expandAll();
        SelectionCategory snippetCat4 = (SelectionCategory)this.dialog.categories.get("Composite Policies");
        SchemaDialogTest.assertEquals((String)"Should have 3 snippets now, after the refresh call and after loading", (int)3, (int)snippetCat4.getEntries().size());
    }

    public void testDoubleClickInTree() throws Exception {
        TestSchemaProvider sp = new TestSchemaProvider();
        sp.schemas.put("http://www.example.com/xsd/2006/02/test_reliable", SchemaDialogTest.loadSchema("example_test_reliable.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2006/02/test", SchemaDialogTest.loadSchema("example_test.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2006/02/test_audit", SchemaDialogTest.loadSchema("example_test_audit.xsd"));
        String relSnippet = "<example:Reliable xmlns:example=\"http://www.example.com/xsd/2006/02/test_reliable\"/>";
        sp.snippets.put("Simple Reliable", relSnippet);
        sp.snippets.put("Another Snippet", relSnippet);
        this.schemaProviderHolder.setProvider(sp);
        this.dialog.open();
        TreeViewer viewer = this.dialog.getTreeViewer();
        viewer.expandAll();
        Shell shell = this.dialog.getShell();
        SchemaDialogTest.assertFalse((String)"Precondition failed", (boolean)shell.isDisposed());
        Tree tree = viewer.getTree();
        TreeItem[] categories = tree.getItems();
        SchemaDialogTest.assertEquals((String)"Should be 2 categories", (int)2, (int)categories.length);
        SchemaDialogTest.assertEquals((String)"Uncategorized", (String)categories[0].getText());
        TreeItem[] schemas = categories[0].getItems();
        SchemaDialogTest.assertEquals((String)"Should be 3 schemas in the 'Other' category", (int)3, (int)schemas.length);
        viewer.setSelection((ISelection)new StructuredSelection(categories[0].getData()), true);
        this.dialog.treeDoubleClicked(new DoubleClickEvent((Viewer)viewer, viewer.getSelection()));
        SchemaDialogTest.assertFalse((String)"Dialog should not have been closed with the double click as this is a category", (boolean)shell.isDisposed());
        viewer.setSelection((ISelection)new StructuredSelection(schemas[0].getData()), true);
        this.dialog.treeDoubleClicked(new DoubleClickEvent((Viewer)viewer, viewer.getSelection()));
        SchemaDialogTest.assertTrue((String)"Dialog should have been closed with the double click as this is a schema", (boolean)shell.isDisposed());
    }

    public void testStatusLine() throws Exception {
        TestSchemaProvider sp = new TestSchemaProvider();
        sp.schemas.put("http://www.example.com/xsd/2006/02/test_reliable", SchemaDialogTest.loadSchema("example_test_reliable.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2006/02/test_secure2", SchemaDialogTest.loadSchema("example_test_secure2.xsd"));
        String relSnippet = "<example:Reliable xmlns:example=\"http://www.example.com/xsd/2006/02/test_reliable\"/>";
        sp.snippets.put("Simple Reliable", relSnippet);
        TestSchemaProviderDecorator spd = new TestSchemaProviderDecorator(sp);
        this.schemaProviderHolder.setProvider(spd);
        this.dialog.open();
        this.dialog.getTreeViewer().expandAll();
        CLabel statusLine = (CLabel)this.getWidget((Composite)this.dialog.getShell(), CLabel.class, "getAlignment", "16384");
        SchemaDialogTest.assertEquals((String)"Please select a policy", (String)statusLine.getText());
        SelectionCategory otherCat = (SelectionCategory)this.dialog.categories.get("Uncategorized");
        SchemaElement firstPolicy = (SchemaElement)otherCat.getEntries().iterator().next();
        SchemaDialogTest.assertEquals((String)"Precondition failed", (String)"Reliable", (String)firstPolicy.getName());
        this.dialog.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)firstPolicy));
        SchemaDialogTest.assertEquals((String)"", (String)statusLine.getText());
        SchemaElement secondPolicy = (SchemaElement)new ArrayList(otherCat.getEntries()).get(1);
        SchemaDialogTest.assertEquals((String)"Precondition failed", (String)"security", (String)secondPolicy.getName());
        this.dialog.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)secondPolicy));
        SchemaDialogTest.assertEquals((String)"Another Security Policy", (String)statusLine.getText());
        SelectionCategory snippetCat = (SelectionCategory)this.dialog.categories.get("Composite Policies");
        this.dialog.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)snippetCat));
        SchemaDialogTest.assertEquals((String)"Please select a policy", (String)statusLine.getText());
        XMLSnippet firstSnippet = (XMLSnippet)snippetCat.getEntries().iterator().next();
        SchemaDialogTest.assertEquals((String)"Precondition failed", (String)"Simple Reliable", (String)firstSnippet.getName());
        this.dialog.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)firstSnippet));
        SchemaDialogTest.assertEquals((String)"OK", (String)statusLine.getText());
    }

    public void testShadowedPolicies() throws Exception {
        TestSchemaProvider sp = new TestSchemaProvider();
        sp.schemas.put("http://www.example.com/xsd/2006/02/test_logging", SchemaDialogTest.loadSchema("example_test_logging.xsd"));
        sp.schemas.put("http://www.example.com/xsd/2006/02/test", SchemaDialogTest.loadSchema("example_test.xsd"));
        SchemaRegistry sr = SchemaRegistry.getDefault();
        SchemaElement se = (SchemaElement)sr.resolveSchemaFromXML(sp.getSchema("http://www.example.com/xsd/2006/02/test_logging"), false, new ISchemaProvider[0]).get(0);
        XMLInstanceElement xi = new XMLInstanceElement(se);
        SchemaProviderFilterWrapper spw = new SchemaProviderFilterWrapper((ISchemaProvider)sp, Collections.singletonList(xi));
        this.dialog.setSchemaProvider((ISchemaProvider)spw);
        this.dialog.setShadowProviders(new IShadowProvider[]{spw.getShadowProvider()});
        this.dialog.open();
        this.dialog.getTreeViewer().expandAll();
        SelectionCategory firstCat = (SelectionCategory)this.dialog.categories.get("Uncategorized");
        ArrayList l = new ArrayList(firstCat.getEntries());
        SchemaDialogTest.assertEquals((int)2, (int)l.size());
        SchemaDialogTest.assertTrue((boolean)(l.get(0) instanceof ShadowEntry));
        SchemaDialogTest.assertTrue((boolean)(l.get(1) instanceof SchemaElement));
        this.dialog.getTreeViewer().setSelection((ISelection)new StructuredSelection(l.get(1)), true);
        SchemaDialogTest.assertTrue((boolean)this.dialog.getOkButton().getEnabled());
        this.dialog.getTreeViewer().setSelection((ISelection)new StructuredSelection(l.get(0)), true);
        SchemaDialogTest.assertFalse((boolean)this.dialog.getOkButton().getEnabled());
    }

    public void testSchemaWithImports() throws Exception {
        TestSchemaProvider sp = new TestSchemaProvider();
        sp.schemas.put("http://www.example.com/test_importer_2", SchemaDialogTest.loadSchema("example_test_importer_2.xsd"));
        sp.schemas.put("http://www.example.com/test_importee_2", SchemaDialogTest.loadSchema("example_test_importee_2.xsd"));
        this.schemaProviderHolder.setProvider(sp);
        this.dialog.open();
        this.dialog.getTreeViewer().expandAll();
        SelectionCategory firstCat = (SelectionCategory)this.dialog.categories.get("Uncategorized");
        SchemaDialogTest.assertEquals((int)1, (int)firstCat.getEntries().size());
        SchemaElement el = (SchemaElement)firstCat.getEntries().iterator().next();
        SchemaDialogTest.assertEquals((String)"example:TestImporter2", (String)el.getDisplayName());
        List subEls = el.getMinimalSubElementList();
        SchemaDialogTest.assertEquals((int)1, (int)subEls.size());
        SchemaDialogTest.assertEquals((String)"wibble", (String)((SchemaElement)subEls.get(0)).getDisplayName());
    }

    private Widget getWidget(Composite composite, Class cls, String methodName, String methodResult) {
        ArrayList toCheck = new ArrayList();
        toCheck.addAll(Arrays.asList(composite.getChildren()));
        if (composite instanceof ToolBar) {
            toCheck.addAll(Arrays.asList(((ToolBar)composite).getItems()));
        }
        for (Widget c : toCheck) {
            Widget w;
            if (cls.isAssignableFrom(c.getClass())) {
                try {
                    Method m = cls.getMethod(methodName, new Class[0]);
                    Object r = m.invoke((Object)c, new Object[0]);
                    if (methodResult.equals(r.toString())) {
                        return c;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!(c instanceof Composite) || (w = this.getWidget((Composite)c, cls, methodName, methodResult)) == null) continue;
            return w;
        }
        return null;
    }

    private static String loadSchema(String name) throws IOException {
        InputStream is = TestSchemaProvider.class.getClassLoader().getResource("/" + name).openStream();
        try {
            String string = new String(InputStreamHelper.drain((InputStream)is));
            return string;
        }
        finally {
            is.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SchemaProviderHolder
    implements ISchemaProvider {
        ISchemaProvider provider;

        private SchemaProviderHolder() {
        }

        private void setProvider(ISchemaProvider p) {
            this.provider = p;
        }

        public String getSchema(String qname) {
            return this.provider.getSchema(qname);
        }

        public String getSnippet(String name) {
            return this.provider.getSnippet(name);
        }

        public Collection<String> listSchemaNamespaces(String filter) {
            return this.provider.listSchemaNamespaces(filter);
        }

        public Collection<String> listSnippets(String filter) {
            return this.provider.listSnippets(filter);
        }

        public void refresh() {
            this.provider.refresh();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestSchemaProvider
    implements ISchemaProvider {
        protected Map<String, String> schemas = new LinkedHashMap<String, String>();
        protected Map<String, String> snippets = new LinkedHashMap<String, String>();

        private TestSchemaProvider() {
        }

        public String getSchema(String qname) {
            return this.schemas.get(qname);
        }

        public String getSnippet(String name) {
            return this.snippets.get(name);
        }

        public Collection<String> listSchemaNamespaces(String filter) {
            return this.schemas.keySet();
        }

        public Collection<String> listSnippets(String filter) {
            return this.snippets.keySet();
        }

        public void refresh() {
        }

        /* synthetic */ TestSchemaProvider(TestSchemaProvider testSchemaProvider, TestSchemaProvider testSchemaProvider2) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestSchemaProviderDecorator
    implements ISchemaProvider {
        private final ISchemaProvider delegate;
        private boolean listSnippetsCalled = false;

        private TestSchemaProviderDecorator(ISchemaProvider sp) {
            this.delegate = sp;
        }

        public String getSchema(String namespace) {
            return this.delegate.getSchema(namespace);
        }

        public String getSnippet(String name) {
            return this.delegate.getSnippet(name);
        }

        public Collection<String> listSchemaNamespaces(String filter) {
            return this.delegate.listSchemaNamespaces(filter);
        }

        public Collection<String> listSnippets(String filter) {
            this.listSnippetsCalled = true;
            return this.delegate.listSnippets(filter);
        }

        public void refresh() {
            this.delegate.refresh();
        }
    }
}

