/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.schema;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.stp.ui.xef.schema.SchemaAttribute;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.ui.xef.schema.SchemaRegistry;
import org.eclipse.stp.ui.xef.schema.ValueType;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.util.InputStreamHelper;

public class SchemaRegistryTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        SchemaRegistry.getDefault().clear();
    }

    public void testSchemaParser() throws Exception {
        URL schemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_logging.xsd");
        SchemaRegistry sr = SchemaRegistry.getDefault();
        sr.resolveSchemaFromURL(schemaURL.toString(), new ISchemaProvider[0]);
        List l = sr.getEntryElements("http://www.example.com/xsd/2006/02/test_logging", false, true, new ISchemaProvider[0]);
        SchemaRegistryTest.assertEquals((int)1, (int)l.size());
        SchemaElement loggingElement = (SchemaElement)l.get(0);
        SchemaRegistryTest.assertEquals((String)"logging", (String)loggingElement.getName());
        List sa = loggingElement.getAttributes();
        SchemaRegistryTest.assertEquals((int)1, (int)sa.size());
        SchemaAttribute levelAttr = (SchemaAttribute)sa.get(0);
        SchemaRegistryTest.assertEquals((String)"level", (String)levelAttr.getName());
        SchemaRegistryTest.assertEquals((Object)ValueType.ENUMERATION, (Object)levelAttr.getValue().getType());
        SchemaRegistryTest.assertEquals(Arrays.asList("Fatal", "Error", "Warning", "Info", "Debug"), (Object)levelAttr.getValue().getAllowedValues());
        List nested = loggingElement.getNestedElements(new LinkedList());
        SchemaRegistryTest.assertEquals((int)2, (int)nested.size());
        SchemaRegistryTest.assertEquals((String)"ConsoleLogger", (String)((SchemaElement)nested.get(0)).getName());
        SchemaElement consoleLogger = (SchemaElement)nested.get(0);
        SchemaElement fileLogger = (SchemaElement)nested.get(1);
        SchemaRegistryTest.assertEquals((String)"FileLogger", (String)fileLogger.getName());
        List fl0 = fileLogger.getNestedElements(new LinkedList());
        SchemaRegistryTest.assertEquals((int)3, (int)fl0.size());
        SchemaElement headerElement = (SchemaElement)fl0.get(0);
        SchemaRegistryTest.assertEquals((String)"Header", (String)headerElement.getName());
        List fl1 = fileLogger.getNestedElements(Arrays.asList(headerElement));
        SchemaRegistryTest.assertEquals((String)"LinePrefix", (String)((SchemaElement)fl1.get(0)).getName());
        SchemaRegistryTest.assertEquals((String)"Footer", (String)((SchemaElement)fl1.get(1)).getName());
        SchemaElement footerElement = (SchemaElement)fl1.get(1);
        SchemaRegistryTest.assertEquals((int)2, (int)fl1.size());
        List fl2 = fileLogger.getNestedElements(Arrays.asList(headerElement, footerElement));
        SchemaRegistryTest.assertEquals((int)1, (int)fl2.size());
        List fl3 = fileLogger.getNestedElements(Arrays.asList(footerElement));
        SchemaRegistryTest.assertEquals((int)2, (int)fl3.size());
        SchemaRegistryTest.assertEquals((int)0, (int)loggingElement.getNestedElements(Arrays.asList(consoleLogger)).size());
    }

    public void testMinimalSequenceElements() throws Exception {
        URL schemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test.xsd");
        SchemaRegistry sr = SchemaRegistry.getDefault();
        sr.resolveSchemaFromURL(schemaURL.toString(), new ISchemaProvider[0]);
        List l = sr.getEntryElements("http://www.example.com/xsd/2006/02/test", true, true, new ISchemaProvider[0]);
        SchemaRegistryTest.assertEquals((int)1, (int)l.size());
        SchemaElement routingElement = (SchemaElement)l.get(0);
        SchemaRegistryTest.assertEquals((String)"Routing", (String)routingElement.getName());
        SchemaElement sub1Element = routingElement.getNestedElement("sub1");
        SchemaElement sub1_1Element = sub1Element.getNestedElement("sub1_1");
        SchemaElement sub1_3Element = sub1Element.getNestedElement("sub1_3");
        SchemaElement sub1_4Element = sub1Element.getNestedElement("sub1_4");
        SchemaElement sub1_5Element = sub1Element.getNestedElement("sub1_5");
        List minimalNested = sub1Element.getMinimalSubElementList();
        SchemaRegistryTest.assertEquals(Arrays.asList(sub1_1Element, sub1_3Element, sub1_4Element, sub1_4Element, sub1_5Element, sub1_5Element, sub1_5Element), (Object)minimalNested);
    }

    public void testNestedSequenceInChoice() throws Exception {
        URL schemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/test_seq_in_choice.xsd");
        SchemaRegistry sr = SchemaRegistry.getDefault();
        sr.resolveSchemaFromURL(schemaURL.toString(), new ISchemaProvider[0]);
        List l = sr.getEntryElements("http://www.example.com/xsd/2006/02/test", true, true, new ISchemaProvider[0]);
        SchemaRegistryTest.assertEquals((int)1, (int)l.size());
        SchemaElement baseElement = (SchemaElement)l.get(0);
        SchemaRegistryTest.assertEquals((String)"Test", (String)baseElement.getName());
        List nested = baseElement.getNestedElements(new LinkedList());
        SchemaRegistryTest.assertEquals((String)"Wrong number of elements selected", (int)3, (int)nested.size());
    }

    public void testTopLevelElements() throws Exception {
        URL schemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_routing.xsd");
        SchemaRegistry sr = SchemaRegistry.getDefault();
        sr.resolveSchemaFromURL(schemaURL.toString(), new ISchemaProvider[0]);
        List l = sr.getEntryElements("http://www.example.com/xsd/2006/02/test_routing", true, true, new ISchemaProvider[0]);
        SchemaRegistryTest.assertEquals((int)1, (int)l.size());
        SchemaElement baseElement = (SchemaElement)l.get(0);
        SchemaRegistryTest.assertEquals((String)"Routing", (String)baseElement.getName());
    }

    public void testNoStackOverflowWithRecursion() throws Exception {
        URL schemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_recursion.xsd");
        SchemaRegistry sr = SchemaRegistry.getDefault();
        sr.resolveSchemaFromURL(schemaURL.toString(), new ISchemaProvider[0]);
        List l = sr.getEntryElements("http://www.example.com/xsd/protocol/tagged/2006/12", true, true, new ISchemaProvider[0]);
        SchemaRegistryTest.assertEquals((int)2, (int)l.size());
        SchemaElement baseElement = (SchemaElement)l.get(0);
        SchemaRegistryTest.assertEquals((String)"binding", (String)baseElement.getName());
    }

    public void testLoadingFromXMLString() throws Exception {
        String schema = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"    targetNamespace=\"http://www.example.com/xsd/2006/02/access_control\"    xmlns:tns=\"http://www.example.com/xsd/2006/02/access_control\">    <xs:element name=\"access_control\"/></xs:schema>";
        SchemaRegistry sr = SchemaRegistry.getDefault();
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        int numfiles = tempDir.list().length;
        sr.resolveSchemaFromXML(schema, true, new ISchemaProvider[0]);
        SchemaRegistryTest.assertEquals((String)"The temporary file was probably not removed", (int)numfiles, (int)tempDir.list().length);
        List l = sr.getEntryElements("http://www.example.com/xsd/2006/02/access_control", false, true, new ISchemaProvider[0]);
        SchemaRegistryTest.assertEquals((int)1, (int)l.size());
        SchemaElement aclElement = (SchemaElement)l.get(0);
        SchemaRegistryTest.assertEquals((String)"access_control", (String)aclElement.getName());
        SchemaRegistryTest.assertEquals((String)"http://www.example.com/xsd/2006/02/access_control", (String)aclElement.getNameSpace());
    }

    public void testSchemaResolutionWhenNotPreviouslyRegistered() throws Exception {
        SchemaRegistry sr = new SchemaRegistry(){

            public List<SchemaElement> resolveSchemaFromURL(String url, ISchemaProvider ... providers) throws Exception {
                if (url.equals("http://www.example.com/xsd/2006/02/tx")) {
                    return this.resolveSchemaFromXML("<?xml version=\"1.0\" encoding=\"UTF-8\"?><xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"    targetNamespace=\"http://www.example.com/xsd/2006/02/tx\"    xmlns:tns=\"http://www.example.com/xsd/2006/02/tx\">    <xs:element name=\"transactionality\"/></xs:schema>", true, providers);
                }
                return super.resolveSchemaFromURL(url, providers);
            }
        };
        List l = sr.getEntryElements("http://www.example.com/xsd/2006/02/tx", true, true, new ISchemaProvider[0]);
        SchemaRegistryTest.assertEquals((int)1, (int)l.size());
        SchemaElement aclElement = (SchemaElement)l.get(0);
        SchemaRegistryTest.assertEquals((String)"transactionality", (String)aclElement.getName());
        SchemaRegistryTest.assertEquals((String)"http://www.example.com/xsd/2006/02/tx", (String)aclElement.getNameSpace());
    }

    public void testNoSchemaResolutionWhenNotPreviouslyRegistered() throws Exception {
        SchemaRegistry sr = new SchemaRegistry(){

            public List<SchemaElement> resolveSchemaFromURL(String url, ISchemaProvider ... providers) throws Exception {
                if (url.equals("http://www.example.com/xsd/2006/02/tx")) {
                    return this.resolveSchemaFromXML("<?xml version=\"1.0\" encoding=\"UTF-8\"?><xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"    targetNamespace=\"http://www.example.com/xsd/2006/02/tx\"    xmlns:tns=\"http://www.example.com/xsd/2006/02/tx\">    <xs:element name=\"transactionality\"/></xs:schema>", true, providers);
                }
                return super.resolveSchemaFromURL(url, providers);
            }
        };
        SchemaRegistryTest.assertNull((String)"Should get null because the schema was not previously registered, and were not resolving", (Object)sr.getEntryElements("http://www.example.com/xsd/2006/02/tx", false, true, new ISchemaProvider[0]));
    }

    public void testResolveThroughSchemaProvider() throws Exception {
        SchemaRegistry sr = new SchemaRegistry();
        ISchemaProvider sp = new ISchemaProvider(){

            public String getSchema(String ns) {
                if ("http://www.example.com/xsd/2006/02/tx".equals(ns)) {
                    return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"    targetNamespace=\"http://www.example.com/xsd/2006/02/tx\"    xmlns:tns=\"http://www.example.com/xsd/2006/02/tx\">    <xs:element name=\"transactionality\"/></xs:schema>";
                }
                return null;
            }

            public String getSnippet(String name) {
                return null;
            }

            public Collection<String> listSchemaNamespaces(String filter) {
                return Arrays.asList("http://www.example.com/xsd/2006/02/tx");
            }

            public Collection<String> listSnippets(String filter) {
                return Collections.emptyList();
            }

            public void refresh() {
            }
        };
        List l = sr.getEntryElements("http://www.example.com/xsd/2006/02/tx", true, true, new ISchemaProvider[]{sp});
        SchemaRegistryTest.assertEquals((int)1, (int)l.size());
        SchemaElement txElement = (SchemaElement)l.get(0);
        SchemaRegistryTest.assertEquals((String)"transactionality", (String)txElement.getName());
        SchemaRegistryTest.assertEquals((String)"http://www.example.com/xsd/2006/02/tx", (String)txElement.getNameSpace());
    }

    public void testDocumentationInAnnotation() throws Exception {
        String schema = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"    targetNamespace=\"http://www.example.com/xsd/2006/02/access_control\"    xmlns:tns=\"http://www.example.com/xsd/2006/02/access_control\">    <xs:element name=\"access_control\">       <xs:annotation>           <xs:documentation>The audit policy provides auditing information in the service's audit logs. Information provided concerns the usage of the service and the overall health of the service. <H1>Also contains XHTML!</H1>           </xs:documentation >       </xs:annotation>    </xs:element></xs:schema>";
        SchemaRegistry sr = SchemaRegistry.getDefault();
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        int numfiles = tempDir.list().length;
        sr.resolveSchemaFromXML(schema, true, new ISchemaProvider[0]);
        SchemaRegistryTest.assertEquals((String)"The temporary file was probably not removed", (int)numfiles, (int)tempDir.list().length);
        List l = sr.getEntryElements("http://www.example.com/xsd/2006/02/access_control", false, true, new ISchemaProvider[0]);
        SchemaRegistryTest.assertEquals((int)1, (int)l.size());
        SchemaElement aclElement = (SchemaElement)l.get(0);
        SchemaRegistryTest.assertEquals((String)"access_control", (String)aclElement.getName());
        SchemaRegistryTest.assertEquals((String)"http://www.example.com/xsd/2006/02/access_control", (String)aclElement.getNameSpace());
        SchemaRegistryTest.assertEquals((String)"The audit policy provides auditing information in the service's audit logs. Information provided concerns the usage of the service and the overall health of the service. <H1>Also contains XHTML!</H1>", (String)aclElement.getDocumentation().trim());
    }

    public void testDocumentationWithOddSpacingInTags() throws Exception {
        String schema = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"    targetNamespace=\"http://www.example.com/xsd/2006/02/acl\"    xmlns:tns=\"http://www.example.com/xsd/2006/02/acl\">    <xs:element name=\"acl\">       <xs:annotation>           <xs:documentation      >The audit policy provides auditing information in the service's audit logs. Information provided concerns the usage of the service and the overall health of the service. <H1>Also contains XHTML!</H1>           </xs:documentation>       </xs:annotation>    </xs:element></xs:schema>";
        SchemaRegistry sr = SchemaRegistry.getDefault();
        sr.resolveSchemaFromXML(schema, true, new ISchemaProvider[0]);
        List l = sr.getEntryElements("http://www.example.com/xsd/2006/02/acl", false, true, new ISchemaProvider[0]);
        SchemaRegistryTest.assertEquals((int)1, (int)l.size());
        SchemaElement aclElement = (SchemaElement)l.get(0);
        SchemaRegistryTest.assertEquals((String)"acl", (String)aclElement.getName());
        SchemaRegistryTest.assertEquals((String)"http://www.example.com/xsd/2006/02/acl", (String)aclElement.getNameSpace());
        SchemaRegistryTest.assertEquals((String)"The audit policy provides auditing information in the service's audit logs. Information provided concerns the usage of the service and the overall health of the service. <H1>Also contains XHTML!</H1>", (String)aclElement.getDocumentation().trim());
    }

    public void testNoDocumentationInAnnotation() throws Exception {
        String schema = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"    targetNamespace=\"http://www.example.com/xsd/2006/02/access_control\"    xmlns:tns=\"http://www.example.com/xsd/2006/02/access_control\">    <xs:element name=\"access_control\">       <xs:annotation>           <xs:appinfo>The audit policy provides auditing information in the service's audit logs. Information provided concerns the usage of the service and the overall health of the service.               <subtag>Some other subtag               </subtag>           </xs:appinfo>       </xs:annotation>    </xs:element></xs:schema>";
        SchemaRegistry sr = SchemaRegistry.getDefault();
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        int numfiles = tempDir.list().length;
        sr.resolveSchemaFromXML(schema, true, new ISchemaProvider[0]);
        SchemaRegistryTest.assertEquals((String)"The temporary file was probably not removed", (int)numfiles, (int)tempDir.list().length);
        List l = sr.getEntryElements("http://www.example.com/xsd/2006/02/access_control", false, true, new ISchemaProvider[0]);
        SchemaRegistryTest.assertEquals((int)1, (int)l.size());
        SchemaElement aclElement = (SchemaElement)l.get(0);
        SchemaRegistryTest.assertEquals((String)"access_control", (String)aclElement.getName());
        SchemaRegistryTest.assertEquals((String)"http://www.example.com/xsd/2006/02/access_control", (String)aclElement.getNameSpace());
        SchemaRegistryTest.assertNull((Object)aclElement.getDocumentation());
    }

    public void testI18NDocumentation1() throws Exception {
        URL schemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_i18n_policy.xsd");
        SchemaRegistry sr = SchemaRegistry.getDefault();
        Locale prevLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.ENGLISH);
            SchemaElement el = (SchemaElement)sr.resolveSchemaFromURL(schemaURL.toString(), new ISchemaProvider[0]).get(0);
            SchemaRegistryTest.assertNull((String)"No English or default documentation found at this level so should return nothing", (Object)el.getDocumentation());
            SchemaRegistryTest.assertEquals((String)"Some text in English", (String)el.getAttribute("attr1").getDocumentation().trim());
            SchemaRegistryTest.assertNull((Object)el.getAttribute("attr2").getDocumentation());
            SchemaRegistryTest.assertNull((Object)el.getAttribute("attr3").getDocumentation());
        }
        finally {
            Locale.setDefault(prevLocale);
        }
    }

    public void testI18NDocumentation2() throws Exception {
        if (File.separatorChar == '/') {
            System.out.println("Skipping this test on this platform: " + this.getName());
            return;
        }
        URL schemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_i18n_policy.xsd");
        SchemaRegistry sr = SchemaRegistry.getDefault();
        Locale prevLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.FRENCH);
            SchemaElement el = (SchemaElement)sr.resolveSchemaFromURL(schemaURL.toString(), new ISchemaProvider[0]).get(0);
            SchemaRegistryTest.assertEquals((String)"le fa\u00e7ade est ovo\u00efde comme un \u009cuf", (String)el.getDocumentation().trim());
            SchemaRegistryTest.assertEquals((String)"This is the default language", (String)el.getAttribute("attr1").getDocumentation().trim());
            SchemaRegistryTest.assertNull((Object)el.getAttribute("attr2").getDocumentation());
            SchemaRegistryTest.assertNull((Object)el.getAttribute("attr3").getDocumentation());
        }
        finally {
            Locale.setDefault(prevLocale);
        }
    }

    public void testI18NDocumentationISO639_2() throws Exception {
        if (File.separatorChar == '/') {
            System.out.println("Skipping this test on this platform: " + this.getName());
            return;
        }
        URL schemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_i18n_policy.xsd");
        SchemaRegistry sr = SchemaRegistry.getDefault();
        Locale prevLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.GERMAN);
            SchemaElement el = (SchemaElement)sr.resolveSchemaFromURL(schemaURL.toString(), new ISchemaProvider[0]).get(0);
            SchemaRegistryTest.assertEquals((String)"Schweinefleisch mit Kartoffelsalat und Schinken!", (String)el.getDocumentation().trim());
            SchemaRegistryTest.assertEquals((String)"Wir m\u00f6chten gerne Fu\u00dfball spielen", (String)el.getAttribute("attr1").getDocumentation().trim());
            SchemaRegistryTest.assertNull((Object)el.getAttribute("attr2").getDocumentation());
            SchemaRegistryTest.assertNull((Object)el.getAttribute("attr3").getDocumentation());
        }
        finally {
            Locale.setDefault(prevLocale);
        }
    }

    public void testCaching() throws Exception {
        String schema1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"    targetNamespace=\"http://www.example.com/xsd/2006/02/access_control\"    xmlns:tns=\"http://www.example.com/xsd/2006/02/access_control\">    <xs:element name=\"access_control\">      <xs:complexType>        <xs:attribute name=\"test1\" type=\"xs:string\" />      </xs:complexType>    </xs:element></xs:schema>";
        SchemaRegistry sr = SchemaRegistry.getDefault();
        List x1 = sr.resolveSchemaFromXML(schema1, false, new ISchemaProvider[0]);
        SchemaRegistryTest.assertNotNull((Object)x1);
        SchemaRegistryTest.assertEquals((int)1, (int)x1.size());
        SchemaElement se1 = (SchemaElement)x1.get(0);
        SchemaRegistryTest.assertEquals((int)1, (int)se1.getAttributes().size());
        SchemaRegistryTest.assertEquals((String)"test1", (String)se1.getAttribute("test1").getName());
        SchemaRegistryTest.assertNull((String)"Should not be able to retrieve the schema as it wasn't cached", (Object)sr.getEntryElements("http://www.example.com/xsd/2006/02/access_control", false, false, new ISchemaProvider[0]));
        String schema2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"    targetNamespace=\"http://www.example.com/xsd/2006/02/access_control\"    xmlns:tns=\"http://www.example.com/xsd/2006/02/access_control\">    <xs:element name=\"access_control\">      <xs:complexType>        <xs:attribute name=\"test2\" type=\"xs:string\" />      </xs:complexType>    </xs:element></xs:schema>";
        List x2 = sr.resolveSchemaFromXML(schema2, true, new ISchemaProvider[0]);
        SchemaRegistryTest.assertNotNull((Object)x2);
        SchemaRegistryTest.assertEquals((int)1, (int)x2.size());
        SchemaElement se2 = (SchemaElement)x2.get(0);
        SchemaRegistryTest.assertEquals((int)1, (int)se2.getAttributes().size());
        SchemaRegistryTest.assertEquals((String)"test2", (String)se2.getAttribute("test2").getName());
        SchemaRegistryTest.assertNull((Object)se2.getAttribute("test1"));
        List x3 = sr.getEntryElements("http://www.example.com/xsd/2006/02/access_control", false, true, new ISchemaProvider[0]);
        SchemaRegistryTest.assertEquals((String)"Should have returned the same elements as before, as they were now cached", (Object)x2, (Object)x3);
        String schema4 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"    targetNamespace=\"http://www.example.com/xsd/2006/02/access_control\"    xmlns:tns=\"http://www.example.com/xsd/2006/02/access_control\">    <xs:element name=\"access_control\">      <xs:complexType>        <xs:attribute name=\"test4\" type=\"xs:string\" />      </xs:complexType>    </xs:element></xs:schema>";
        List x4 = sr.resolveSchemaFromXML(schema4, false, new ISchemaProvider[0]);
        SchemaRegistryTest.assertNotNull((Object)x4);
        SchemaRegistryTest.assertEquals((int)1, (int)x4.size());
        SchemaElement se4 = (SchemaElement)x4.get(0);
        SchemaRegistryTest.assertEquals((int)1, (int)se4.getAttributes().size());
        SchemaRegistryTest.assertEquals((String)"test4", (String)se4.getAttribute("test4").getName());
        List x5 = sr.getEntryElements("http://www.example.com/xsd/2006/02/access_control", false, true, new ISchemaProvider[0]);
        SchemaRegistryTest.assertEquals((String)"Should have returned the cached instance, not the latest one", (Object)x2, (Object)x5);
    }

    public void testSchemaImport() throws Exception {
        TestSchemaProvider tsp = new TestSchemaProvider();
        tsp.schemas.put("http://www.example.com/test_importee_2", new String(InputStreamHelper.drain((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResource("example_test_importee_2.xsd").openStream())));
        URL importerURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("example_test_importer_2.xsd");
        SchemaRegistry sr = SchemaRegistry.getDefault();
        List r = sr.resolveSchemaFromURL(importerURL.toString(), new ISchemaProvider[]{tsp});
        SchemaRegistryTest.assertEquals((int)1, (int)r.size());
        SchemaElement el = (SchemaElement)r.get(0);
        List l = el.getMinimalSubElementList();
        SchemaRegistryTest.assertEquals((int)1, (int)l.size());
        SchemaRegistryTest.assertEquals((String)"wibble", (String)((SchemaElement)l.get(0)).getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestSchemaProvider
    implements ISchemaProvider {
        protected Map<String, String> schemas = new LinkedHashMap<String, String>();
        protected Map<String, String> snippets = new LinkedHashMap<String, String>();

        private TestSchemaProvider() {
        }

        public String getSchema(String qname) {
            return this.schemas.get(qname);
        }

        public String getSnippet(String name) {
            return this.snippets.get(name);
        }

        public Collection<String> listSchemaNamespaces(String filter) {
            return this.schemas.keySet();
        }

        public Collection<String> listSnippets(String filter) {
            return this.snippets.keySet();
        }

        public void refresh() {
        }
    }
}

