/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.stp.ui.xef.editor.ControlAccessor;
import org.eclipse.stp.xef.util.QNameHelper;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QNameControlAccessor
implements ControlAccessor {
    private final Combo combo;
    private final Map<String, String> map;

    QNameControlAccessor(Combo c, Map<String, String> m) {
        this.combo = c;
        this.map = m;
    }

    @Override
    public String getValue() {
        return this.combo.getText();
    }

    @Override
    public void setValue(String value) {
        if (this.combo.indexOf(value) == -1 && value.length() != 0) {
            this.combo.add(value, 0);
        }
        this.combo.select(this.combo.indexOf(value));
        this.combo.notifyListeners(13, new Event());
    }

    public String convertToFullName(String qname) {
        String fullName = qname;
        String prefix = QNameHelper.getPrefixFromQName(qname);
        String local = QNameHelper.getLocalFromQName(qname);
        if (this.map != null && this.map.get(prefix) != null) {
            fullName = QNameHelper.convertToFullName(this.map.get(prefix), local);
        }
        return fullName;
    }

    public String[] getQNameValues(String[] values) {
        if (values == null || values.length == 0) {
            return new String[0];
        }
        String[] qnameValues = new String[values.length];
        int i = 0;
        while (i < values.length) {
            qnameValues[i] = this.convertToQName(values[i]);
            ++i;
        }
        return qnameValues;
    }

    public String convertToQName(String fullName) {
        String prefixName = fullName;
        String local = QNameHelper.getLocalNameFromFullName(fullName);
        String namespace = QNameHelper.getNamespaceFromFullName(fullName);
        if (this.map != null) {
            for (String key : this.map.keySet()) {
                if (!namespace.equals(this.map.get(key))) continue;
                prefixName = QNameHelper.convertToQName(key, local);
                break;
            }
        }
        return prefixName;
    }

    public static Map<String, String> createNamespaceMap(Map existingNamespaces, String[] values) {
        HashMap<String, String> map = new HashMap<String, String>(existingNamespaces);
        if (values != null) {
            String[] stringArray = values;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String value = stringArray[n];
                QNameControlAccessor.addPrefixToMap(map, value);
                ++n;
            }
        }
        return map;
    }

    private static void addPrefixToMap(Map<String, String> map, String fullName) {
        if (map == null) {
            return;
        }
        String uri = QNameHelper.getNamespaceFromFullName(fullName);
        if (uri == null || uri.length() == 0) {
            return;
        }
        for (String key : map.keySet()) {
            if (!uri.equals(map.get(key))) continue;
            return;
        }
        String prefixBase = "ns";
        int count = 1;
        String prefix = String.valueOf(prefixBase) + String.valueOf(count);
        while (!QNameControlAccessor.validPrefix(prefix, uri, map)) {
            prefix = String.valueOf(prefixBase) + String.valueOf(++count);
        }
        map.put(prefix, uri);
    }

    private static boolean validPrefix(String prefix, String uri, Map map) {
        return !map.containsKey(prefix);
    }
}

