/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stp.ui.xef.XefPlugin;
import org.eclipse.stp.ui.xef.editor.SelectionCategory;
import org.eclipse.stp.ui.xef.editor.ShadowEntry;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.ui.xef.schema.SchemaRegistry;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.IShadowProvider;
import org.eclipse.stp.xef.XMLSnippet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class SchemaSelectionDialog
extends ElementTreeSelectionDialog {
    public static final String OTHER_CATEGORY_NAME = "Uncategorized";
    public static final String SNIPPET_CATEGORY_NAME = "Composite Policies";
    Combo selectedProduct;
    Map<String, SelectionCategory> categories = new TreeMap<String, SelectionCategory>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (SchemaSelectionDialog.OTHER_CATEGORY_NAME.equals(o1)) {
                if (SchemaSelectionDialog.SNIPPET_CATEGORY_NAME.equals(o2)) {
                    return 1;
                }
                return SchemaSelectionDialog.OTHER_CATEGORY_NAME.equals(o2) ? 0 : 1;
            }
            if (SchemaSelectionDialog.SNIPPET_CATEGORY_NAME.equals(o1)) {
                return SchemaSelectionDialog.SNIPPET_CATEGORY_NAME.equals(o2) ? 0 : 1;
            }
            if (SchemaSelectionDialog.OTHER_CATEGORY_NAME.equals(o2)) {
                return SchemaSelectionDialog.SNIPPET_CATEGORY_NAME.equals(o1) ? 1 : -1;
            }
            return o1.compareTo(o2);
        }
    });
    ISchemaProvider schemaProvider;
    IShadowProvider[] shadowProviders;
    private boolean initialized = false;
    private boolean snippetsInitialized = false;

    public SchemaSelectionDialog(Shell parent, ISchemaProvider sp, IShadowProvider ... shadowed) {
        this(parent, sp, new ContentProviderDelegate(), shadowed);
    }

    private SchemaSelectionDialog(Shell parent, ISchemaProvider sp, ContentProviderDelegate cp, IShadowProvider ... shadowed) {
        super(parent, SchemaSelectionDialog.getLabelProvider(), (ITreeContentProvider)cp);
        cp.setDelegate(this.getContentProvider());
        this.setTitle("Add Policy");
        this.schemaProvider = sp;
        this.shadowProviders = shadowed;
        this.setInput(this.categories);
        this.setMessage("Select a Policy");
        this.setAllowMultiple(false);
        this.setDoubleClickSelects(false);
        this.setEmptyListMessage("No policy found that satisfies the criteria");
        this.setStatusLineAboveButtons(true);
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1) {
                    if (selection[0] instanceof SchemaElement) {
                        String doc = ((SchemaElement)selection[0]).getDocShort();
                        if (doc == null) {
                            doc = "";
                        }
                        return new Status(1, XefPlugin.getDefault().getBundle().getSymbolicName(), 0, doc, null);
                    }
                    if (selection[0] instanceof XMLSnippet) {
                        return Status.OK_STATUS;
                    }
                }
                return new Status(4, XefPlugin.getDefault().getBundle().getSymbolicName(), 1, "Please select a policy", null);
            }
        });
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        result.x = (int)((double)result.x * 1.7);
        return result;
    }

    protected Label createMessageArea(Composite composite) {
        Composite titleComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        titleComposite.setLayout((Layout)layout);
        GridData cgd = new GridData();
        cgd.grabExcessHorizontalSpace = true;
        cgd.horizontalAlignment = 4;
        titleComposite.setLayoutData((Object)cgd);
        Label message = super.createMessageArea(titleComposite);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 1;
        message.setLayoutData((Object)gd);
        Composite toolbarComposite = new Composite(titleComposite, 0);
        GridLayout toolbarGrid = new GridLayout();
        toolbarGrid.numColumns = 1;
        toolbarComposite.setLayout((Layout)toolbarGrid);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalAlignment = 0x1000008;
        toolbarComposite.setLayoutData((Object)gd);
        ToolBar tb = new ToolBar(toolbarComposite, 0x800000);
        tb.setBackground(toolbarComposite.getBackground());
        tb.setForeground(toolbarComposite.getForeground());
        ToolItem ti = new ToolItem(tb, 8);
        ti.setToolTipText("Refresh");
        ti.setImage(XefPlugin.getDefault().getImageRegistry().get("refresh"));
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchemaSelectionDialog.this.refreshContents();
            }
        });
        return message;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer tv = super.createTreeViewer(parent);
        tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SchemaSelectionDialog.this.treeDoubleClicked(event);
            }
        });
        return tv;
    }

    void treeDoubleClicked(DoubleClickEvent event) {
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection) {
            Object item = ((IStructuredSelection)sel).getFirstElement();
            if (this.getOkButton().isEnabled() && !(item instanceof SelectionCategory)) {
                this.okPressed();
            }
        }
    }

    public int open() {
        this.fillContents();
        return super.open();
    }

    private void fillContents() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        SelectionCategory otherCategory = null;
        SchemaRegistry sr = XefPlugin.getDefault().getSchemaRegistry();
        for (String ns : this.schemaProvider.listSchemaNamespaces(null)) {
            List<SchemaElement> elements = null;
            try {
                if (ns == null) continue;
                elements = sr.resolveSchemaFromXML(this.schemaProvider.getSchema(ns), true, this.schemaProvider);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (elements == null) continue;
            for (SchemaElement se : elements) {
                String categoryPath = se.getCategory();
                SelectionCategory dialogCategory = null;
                if (categoryPath != null && categoryPath.length() > 0) {
                    dialogCategory = this.categories.get(categoryPath);
                    if (dialogCategory == null) {
                        dialogCategory = new SelectionCategory(categoryPath);
                        this.categories.put(categoryPath, dialogCategory);
                    }
                } else {
                    if (otherCategory == null) {
                        otherCategory = new SelectionCategory(OTHER_CATEGORY_NAME);
                        this.categories.put(OTHER_CATEGORY_NAME, otherCategory);
                    }
                    dialogCategory = otherCategory;
                }
                dialogCategory.addEntry(se);
            }
        }
        IShadowProvider[] iShadowProviderArray = this.shadowProviders;
        int n = 0;
        int n2 = iShadowProviderArray.length;
        while (n < n2) {
            IShadowProvider shp = iShadowProviderArray[n];
            String[] stringArray = shp.getShadowCategories();
            int n3 = 0;
            int n4 = stringArray.length;
            while (n3 < n4) {
                String category = stringArray[n3];
                SelectionCategory cat = this.categories.get(category);
                if (!SNIPPET_CATEGORY_NAME.equals(cat)) {
                    if (cat == null) {
                        cat = new SelectionCategory(category);
                        this.categories.put(category, cat);
                    }
                    Object[] objectArray = shp.getShadowed(category);
                    int n5 = 0;
                    int n6 = objectArray.length;
                    while (n5 < n6) {
                        Object shadowed = objectArray[n5];
                        if (shadowed instanceof SchemaElement) {
                            cat.addEntry(new ShadowEntry(String.valueOf(((SchemaElement)shadowed).getDisplayName()) + " (" + shp.getReason(shadowed) + ")", false));
                        } else if (shadowed instanceof XMLSnippet) {
                            cat.addEntry(new ShadowEntry(((XMLSnippet)shadowed).toString(), true));
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
            ++n;
        }
        SelectionCategory snippetCategory = new SelectionCategory(SNIPPET_CATEGORY_NAME);
        this.categories.put(SNIPPET_CATEGORY_NAME, snippetCategory);
        this.snippetsInitialized = false;
    }

    private void refreshContents() {
        this.initialized = false;
        this.snippetsInitialized = false;
        XefPlugin.getDefault().getSchemaRegistry().clear();
        this.schemaProvider.refresh();
        this.fillContents();
        this.setInput(this.categories);
        this.getTreeViewer().setInput(this.categories);
    }

    public void setSchemaProvider(ISchemaProvider sp) {
        this.schemaProvider = sp;
        this.initialized = false;
    }

    public void setShadowProviders(IShadowProvider ... s) {
        this.shadowProviders = s;
        this.initialized = false;
    }

    protected TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    private static ILabelProvider getLabelProvider() {
        class CatalogLabelProvider
        implements ILabelProvider,
        IColorProvider {
            CatalogLabelProvider() {
            }

            public Image getImage(Object element) {
                if (element instanceof SelectionCategory) {
                    return XefPlugin.getDefault().getImageRegistry().get("xef_group");
                }
                if (element instanceof XMLSnippet) {
                    return XefPlugin.getDefault().getImageRegistry().get("xef_snippet");
                }
                if (element instanceof ShadowEntry) {
                    return ((ShadowEntry)element).isSnippet() ? XefPlugin.getDefault().getImageRegistry().get("xef_snippet_grey") : XefPlugin.getDefault().getImageRegistry().get("xef_instance_grey");
                }
                return XefPlugin.getDefault().getImageRegistry().get("xef_instance");
            }

            public String getText(Object element) {
                return element.toString();
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Color getBackground(Object element) {
                return null;
            }

            public Color getForeground(Object element) {
                if (element instanceof ShadowEntry) {
                    return Display.getDefault().getSystemColor(15);
                }
                return null;
            }
        }
        return new CatalogLabelProvider();
    }

    private ITreeContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof SelectionCategory) {
                    SelectionCategory sc = (SelectionCategory)parentElement;
                    if (SchemaSelectionDialog.SNIPPET_CATEGORY_NAME.equals(sc.getName()) && !SchemaSelectionDialog.this.snippetsInitialized) {
                        for (String n : SchemaSelectionDialog.this.schemaProvider.listSnippets(null)) {
                            XMLSnippet se = new XMLSnippet(n, SchemaSelectionDialog.this.schemaProvider.getSnippet(n));
                            sc.addEntry(se);
                        }
                        IShadowProvider[] iShadowProviderArray = SchemaSelectionDialog.this.shadowProviders;
                        int n = 0;
                        int n2 = iShadowProviderArray.length;
                        while (n < n2) {
                            IShadowProvider shp = iShadowProviderArray[n];
                            Object[] shadowed = shp.getShadowed(SchemaSelectionDialog.SNIPPET_CATEGORY_NAME);
                            if (shadowed != null) {
                                Object[] objectArray = shadowed;
                                int n3 = 0;
                                int n4 = objectArray.length;
                                while (n3 < n4) {
                                    Object o = objectArray[n3];
                                    if (o != null) {
                                        sc.addEntry(new ShadowEntry(String.valueOf(o.toString()) + " (" + shp.getReason(o) + ")", true));
                                    }
                                    ++n3;
                                }
                            }
                            ++n;
                        }
                        SchemaSelectionDialog.this.snippetsInitialized = true;
                    }
                    return sc.getEntries().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof SelectionCategory;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Map) {
                    return ((Map)inputElement).values().toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private static class ContentProviderDelegate
    implements ITreeContentProvider {
        private ITreeContentProvider delegate;

        private ContentProviderDelegate() {
        }

        public void setDelegate(ITreeContentProvider d) {
            this.delegate = d;
        }

        public void dispose() {
            this.delegate.dispose();
        }

        public Object[] getChildren(Object parentElement) {
            return this.delegate.getChildren(parentElement);
        }

        public Object[] getElements(Object inputElement) {
            return this.delegate.getElements(inputElement);
        }

        public Object getParent(Object element) {
            return this.delegate.getParent(element);
        }

        public boolean hasChildren(Object element) {
            return this.delegate.hasChildren(element);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.delegate.inputChanged(viewer, oldInput, newInput);
        }
    }
}

