/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.XMLSnippet;
import org.eclipse.stp.xef.util.InputStreamHelper;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLSchemaProvider
implements ISchemaProvider {
    Map<String, String> schemas = new HashMap<String, String>();
    Map<String, String> snippets = new HashMap<String, String>();

    public URLSchemaProvider(URL[] urls) throws Exception {
        this(urls, new XMLSnippet[0]);
    }

    public URLSchemaProvider(URL[] urls, XMLSnippet[] snips) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Object[] objectArray = urls;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            URL url = objectArray[n];
            InputStream is = url.openStream();
            try {
                String schema = new String(InputStreamHelper.drain(is));
                Document d = builder.build((InputStream)new ByteArrayInputStream(schema.getBytes()));
                this.schemas.put(d.getRootElement().getNamespace("tns").getURI(), schema);
            }
            finally {
                is.close();
            }
            ++n;
        }
        objectArray = snips;
        n = 0;
        n2 = objectArray.length;
        while (n < n2) {
            Object snip = objectArray[n];
            this.snippets.put(((XMLSnippet)snip).getName(), ((XMLSnippet)snip).getSnippet());
            ++n;
        }
    }

    @Override
    public String getSchema(String ns) {
        return this.schemas.get(ns);
    }

    @Override
    public String getSnippet(String name) {
        return this.snippets.get(name);
    }

    @Override
    public Collection<String> listSchemaNamespaces(String filter) {
        return this.schemas.keySet();
    }

    @Override
    public Collection<String> listSnippets(String filter) {
        return this.snippets.keySet();
    }

    @Override
    public void refresh() {
    }
}

