/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Orientable;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public final class Triangle
extends Shape
implements Orientable {
    protected int direction = 1;
    protected int orientation = 1;
    protected PointList triangle = new PointList(3);

    protected void fillShape(Graphics g) {
        g.fillPolygon(this.triangle);
    }

    protected void outlineShape(Graphics g) {
        g.drawPolygon(this.triangle);
    }

    public void primTranslate(int dx, int dy) {
        super.primTranslate(dx, dy);
        this.triangle.translate(dx, dy);
    }

    public void setDirection(int value) {
        this.orientation = (value & 5) != 0 ? 1 : 0;
        this.direction = value;
        this.revalidate();
        this.repaint();
    }

    public void setOrientation(int value) {
        if (this.orientation == 1 && value == 0) {
            if (this.direction == 1) {
                this.setDirection(8);
            } else {
                this.setDirection(16);
            }
        }
        if (this.orientation == 0 && value == 1) {
            if (this.direction == 8) {
                this.setDirection(1);
            } else {
                this.setDirection(4);
            }
        }
    }

    public void validate() {
        Point p3;
        Point p2;
        Point head;
        int size;
        super.validate();
        Rectangle r = new Rectangle();
        r.setBounds(this.getBounds());
        r.crop(this.getInsets());
        r.resize(-1, -1);
        switch (this.direction & 5) {
            case 0: {
                size = Math.min(r.height / 2, r.width);
                r.x += (r.width - size) / 2;
                break;
            }
            default: {
                size = Math.min(r.height, r.width / 2);
                r.y += (r.height - size) / 2;
            }
        }
        size = Math.max(size, 1);
        switch (this.direction) {
            case 1: {
                head = new Point(r.x + r.width / 2, r.y);
                p2 = new Point(head.x - size, head.y + size);
                p3 = new Point(head.x + size, head.y + size);
                break;
            }
            case 4: {
                head = new Point(r.x + r.width / 2, r.y + size);
                p2 = new Point(head.x - size, head.y - size);
                p3 = new Point(head.x + size, head.y - size);
                break;
            }
            case 8: {
                head = new Point(r.x, r.y + r.height / 2);
                p2 = new Point(head.x + size, head.y - size);
                p3 = new Point(head.x + size, head.y + size);
                break;
            }
            default: {
                head = new Point(r.x + size, r.y + r.height / 2);
                p2 = new Point(head.x - size, head.y - size);
                p3 = new Point(head.x - size, head.y + size);
            }
        }
        this.triangle.removeAllPoints();
        this.triangle.addPoint(head);
        this.triangle.addPoint(p2);
        this.triangle.addPoint(p3);
    }
}

