/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.validate;

import java.util.Iterator;
import org.eclipse.wst.html.core.internal.validate.CMUtil;
import org.eclipse.wst.html.core.internal.validate.ErrorInfoImpl;
import org.eclipse.wst.html.core.internal.validate.MessageFactory;
import org.eclipse.wst.html.core.internal.validate.PrimeValidator;
import org.eclipse.wst.html.core.internal.validate.Segment;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class HTMLAttributeValidator
extends PrimeValidator {
    private static final int REGION_NAME = 1;
    private static final int REGION_VALUE = 2;
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    static /* synthetic */ Class class$0;

    private Segment getErrorSegment(IDOMNode errorNode, int regionType) {
        IDOMElement ownerElement;
        ITextRegion rgn = null;
        switch (regionType) {
            case 1: {
                rgn = errorNode.getNameRegion();
                break;
            }
            case 2: {
                rgn = errorNode.getValueRegion();
                break;
            }
        }
        if (rgn != null && errorNode instanceof IDOMAttr && (ownerElement = (IDOMElement)((IDOMAttr)errorNode).getOwnerElement()) != null) {
            int regionStartOffset = ownerElement.getFirstStructuredDocumentRegion().getStartOffset(rgn);
            int regionLength = rgn.getLength();
            return new Segment(regionStartOffset, regionLength);
        }
        return new Segment(errorNode.getStartOffset(), 0);
    }

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.html.core.internal.validate.HTMLAttributeValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type == clazz || super.isAdapterForType(type);
    }

    public void validate(IndexedRegion node) {
        Element target = (Element)node;
        if (CMUtil.isForeign(target)) {
            return;
        }
        CMElementDeclaration edec = CMUtil.getDeclaration(target);
        if (edec == null) {
            return;
        }
        CMNamedNodeMap declarations = edec.getAttributes();
        NamedNodeMap attrs = target.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            block16: {
                Segment seg;
                Attr a;
                int state;
                int rgnType;
                block18: {
                    String source;
                    CMAttributeDeclaration adec;
                    boolean isXMLAttr;
                    block20: {
                        String desired;
                        block19: {
                            block17: {
                                IDOMAttr xmlattr;
                                rgnType = 1;
                                state = 0;
                                a = (Attr)attrs.item(i);
                                isXMLAttr = a instanceof IDOMAttr;
                                if (isXMLAttr && !(xmlattr = (IDOMAttr)a).isGlobalAttr()) break block16;
                                adec = (CMAttributeDeclaration)declarations.getNamedItem(a.getName());
                                if (adec != null) break block17;
                                if (!this.hasJSPRegion(((IDOMNode)a).getNameRegion())) {
                                    rgnType = 1;
                                    state = 11;
                                }
                                break block18;
                            }
                            if (!CMUtil.isHTML(edec) || CMUtil.isXHTML(edec)) break block19;
                            if (!CMUtil.isBooleanAttr(adec) || !((IDOMAttr)a).hasNameOnly()) break block20;
                            break block16;
                        }
                        String actual = a.getName();
                        if (!actual.equals(desired = adec.getAttrName())) {
                            rgnType = 1;
                            state = 103;
                        }
                    }
                    if (state == 0) {
                        CMDataType attrType = adec.getAttrType();
                        String actualValue = a.getValue();
                        if (attrType.getImpliedValueKind() == 2) {
                            String validValue = attrType.getImpliedValue();
                            if (!actualValue.equals(validValue)) {
                                rgnType = 2;
                                state = 12;
                            }
                        } else {
                            String[] candidates = attrType.getEnumeratedValues();
                            if (candidates != null && candidates.length > 0) {
                                boolean found = false;
                                int index = 0;
                                while (index < candidates.length) {
                                    String candidate = candidates[index];
                                    if (actualValue.equalsIgnoreCase(candidate)) {
                                        found = true;
                                        if (!CMUtil.isCaseSensitive(edec) || actualValue.equals(candidate)) break;
                                        rgnType = 2;
                                        state = 13;
                                        break;
                                    }
                                    ++index;
                                }
                                if (!found && !this.hasJSPRegion(((IDOMNode)a).getValueRegion())) {
                                    rgnType = 2;
                                    state = 12;
                                }
                            }
                        }
                    }
                    if (state == 0 && isXMLAttr && (source = ((IDOMAttr)a).getValueRegionText()) != null) {
                        char firstChar = source.charAt(0);
                        char lastChar = source.charAt(source.length() - 1);
                        if ((this.isQuote(firstChar) || this.isQuote(lastChar)) && lastChar != firstChar) {
                            rgnType = 2;
                            state = 113;
                        }
                    }
                }
                if (state != 0 && (seg = this.getErrorSegment((IDOMNode)a, rgnType)) != null) {
                    this.reporter.report(MessageFactory.createMessage(new ErrorInfoImpl(state, seg, a)));
                }
            }
            ++i;
        }
    }

    private boolean hasJSPRegion(ITextRegion container) {
        if (!(container instanceof ITextRegionContainer)) {
            return false;
        }
        ITextRegionList regions = ((ITextRegionContainer)container).getRegions();
        if (regions == null) {
            return false;
        }
        Iterator e = regions.iterator();
        while (e.hasNext()) {
            String regionType;
            ITextRegion region = (ITextRegion)e.next();
            if (region == null || (regionType = region.getType()) != "XML_TAG_OPEN" && !this.isNestedTagName(regionType)) continue;
            return true;
        }
        return false;
    }

    private boolean isNestedTagName(String regionType) {
        boolean result = regionType.equals("JSP_SCRIPTLET_OPEN") || regionType.equals("JSP_EXPRESSION_OPEN") || regionType.equals("JSP_DECLARATION_OPEN") || regionType.equals("JSP_DIRECTIVE_OPEN");
        return result;
    }

    private boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }
}

