/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.workbench.utility;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.PTAnonymousClassDeclaration;
import org.eclipse.jem.internal.instantiation.PTArrayAccess;
import org.eclipse.jem.internal.instantiation.PTArrayCreation;
import org.eclipse.jem.internal.instantiation.PTArrayInitializer;
import org.eclipse.jem.internal.instantiation.PTBooleanLiteral;
import org.eclipse.jem.internal.instantiation.PTCastExpression;
import org.eclipse.jem.internal.instantiation.PTCharacterLiteral;
import org.eclipse.jem.internal.instantiation.PTClassInstanceCreation;
import org.eclipse.jem.internal.instantiation.PTConditionalExpression;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTFieldAccess;
import org.eclipse.jem.internal.instantiation.PTInfixExpression;
import org.eclipse.jem.internal.instantiation.PTInfixOperator;
import org.eclipse.jem.internal.instantiation.PTInstanceof;
import org.eclipse.jem.internal.instantiation.PTInvalidExpression;
import org.eclipse.jem.internal.instantiation.PTMethodInvocation;
import org.eclipse.jem.internal.instantiation.PTNumberLiteral;
import org.eclipse.jem.internal.instantiation.PTParenthesizedExpression;
import org.eclipse.jem.internal.instantiation.PTPrefixExpression;
import org.eclipse.jem.internal.instantiation.PTPrefixOperator;
import org.eclipse.jem.internal.instantiation.PTStringLiteral;
import org.eclipse.jem.internal.instantiation.PTTypeLiteral;
import org.eclipse.jem.workbench.utility.WorkbenchUtilityMessages;

public class ParseTreeCreationFromAST
extends ASTVisitor {
    protected final Resolver resolver;
    protected PTExpression expression;
    private static HashMap infixOperToParseOper;
    private static HashMap prefixOperToParseOper;

    public ParseTreeCreationFromAST(Resolver resolver) {
        this.resolver = resolver;
    }

    public final PTExpression createExpression(Expression astExpression) {
        try {
            return this.perform(astExpression);
        }
        catch (InvalidExpressionException e) {
            String msg = MessageFormat.format(WorkbenchUtilityMessages.ParseTreeCreationFromAST_0, e.getLocalizedMessage(), astExpression.toString());
            PTInvalidExpression exp = InstantiationFactory.eINSTANCE.createPTInvalidExpression();
            exp.setMessage(msg);
            return exp;
        }
    }

    protected final PTExpression perform(Expression astExpression) {
        if (astExpression != null) {
            this.expression = null;
            astExpression.accept((ASTVisitor)this);
            if (this.expression == null) {
                throw new InvalidExpressionException(MessageFormat.format(WorkbenchUtilityMessages.ParseTreeCreationFromAST_ExpressionTooComplicated_EXC_, astExpression.toString()));
            }
            return this.expression;
        }
        return null;
    }

    public boolean visit(ArrayAccess node) {
        PTArrayAccess aa = InstantiationFactory.eINSTANCE.createPTArrayAccess();
        EList indexes = aa.getIndexes();
        ArrayAccess arrayExp = node;
        while (arrayExp.getNodeType() == 2) {
            ArrayAccess array = arrayExp;
            indexes.add(0, this.perform(array.getIndex()));
            arrayExp = array.getArray();
        }
        aa.setArray(this.perform((Expression)arrayExp));
        this.expression = aa;
        return false;
    }

    public boolean visit(ArrayCreation node) {
        PTArrayCreation ac = InstantiationFactory.eINSTANCE.createPTArrayCreation();
        ac.setType(this.resolver.resolveType((Type)node.getType()));
        EList acDims = ac.getDimensions();
        List nDims = node.dimensions();
        int nsize = nDims.size();
        int i = 0;
        while (i < nsize) {
            acDims.add(this.perform((Expression)nDims.get(i)));
            ++i;
        }
        ac.setInitializer((PTArrayInitializer)this.perform((Expression)node.getInitializer()));
        this.expression = ac;
        return false;
    }

    public boolean visit(ArrayInitializer node) {
        PTArrayInitializer ai = InstantiationFactory.eINSTANCE.createPTArrayInitializer();
        List exps = node.expressions();
        EList aiexps = ai.getExpressions();
        int nexp = exps.size();
        int i = 0;
        while (i < nexp) {
            aiexps.add(this.perform((Expression)exps.get(i)));
            ++i;
        }
        this.expression = ai;
        return false;
    }

    public boolean visit(Assignment node) {
        return false;
    }

    public boolean visit(BooleanLiteral node) {
        PTBooleanLiteral bl = InstantiationFactory.eINSTANCE.createPTBooleanLiteral();
        bl.setBooleanValue(node.booleanValue());
        this.expression = bl;
        return false;
    }

    public boolean visit(CastExpression node) {
        PTCastExpression ct = InstantiationFactory.eINSTANCE.createPTCastExpression();
        ct.setType(this.resolver.resolveType(node.getType()));
        ct.setExpression(this.perform(node.getExpression()));
        this.expression = ct;
        return false;
    }

    public boolean visit(CharacterLiteral node) {
        PTCharacterLiteral cl = InstantiationFactory.eINSTANCE.createPTCharacterLiteral();
        cl.setEscapedValue(node.getEscapedValue());
        cl.setCharValue(node.charValue());
        this.expression = cl;
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (node.getAnonymousClassDeclaration() != null) {
            PTAnonymousClassDeclaration adecl = InstantiationFactory.eINSTANCE.createPTAnonymousClassDeclaration();
            adecl.setDeclaration(node.toString());
            this.expression = adecl;
        } else {
            String type;
            PTClassInstanceCreation cic = InstantiationFactory.eINSTANCE.createPTClassInstanceCreation();
            String string = type = node.getAST().apiLevel() == 2 ? this.resolver.resolveType(node.getName()) : this.resolver.resolveType(node.getType());
            if (type == null) {
                type = node.getAST().apiLevel() == 2 ? node.getName().getFullyQualifiedName() : node.getType().toString();
            }
            cic.setType(type);
            EList args = cic.getArguments();
            List nargs = node.arguments();
            int nsize = nargs.size();
            int i = 0;
            while (i < nsize) {
                args.add(this.perform((Expression)nargs.get(i)));
                ++i;
            }
            this.expression = cic;
        }
        return false;
    }

    public boolean visit(ConditionalExpression node) {
        PTConditionalExpression ce = InstantiationFactory.eINSTANCE.createPTConditionalExpression();
        ce.setCondition(this.perform(node.getExpression()));
        ce.setTrue(this.perform(node.getThenExpression()));
        ce.setFalse(this.perform(node.getElseExpression()));
        this.expression = ce;
        return false;
    }

    public boolean visit(FieldAccess node) {
        this.expression = this.createFieldAccess(node.getName().getIdentifier(), this.perform(node.getExpression()));
        return false;
    }

    protected PTExpression createFieldAccess(String name, PTExpression receiver) {
        PTFieldAccess fa = InstantiationFactory.eINSTANCE.createPTFieldAccess();
        fa.setReceiver(receiver);
        fa.setField(name);
        return fa;
    }

    private final PTInfixOperator getParseInfix(InfixExpression.Operator operator) {
        if (prefixOperToParseOper == null) {
            infixOperToParseOper = new HashMap(5);
            infixOperToParseOper.put(InfixExpression.Operator.AND, PTInfixOperator.AND_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.CONDITIONAL_AND, PTInfixOperator.CONDITIONAL_AND_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.CONDITIONAL_OR, PTInfixOperator.CONDITIONAL_OR_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.DIVIDE, PTInfixOperator.DIVIDE_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.EQUALS, PTInfixOperator.EQUALS_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.GREATER_EQUALS, PTInfixOperator.GREATER_EQUALS_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.GREATER, PTInfixOperator.GREATER_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.LEFT_SHIFT, PTInfixOperator.LEFT_SHIFT_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.LESS_EQUALS, PTInfixOperator.LESS_EQUALS_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.LESS, PTInfixOperator.LESS_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.MINUS, PTInfixOperator.MINUS_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.NOT_EQUALS, PTInfixOperator.NOT_EQUALS_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.OR, PTInfixOperator.OR_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.PLUS, PTInfixOperator.PLUS_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.REMAINDER, PTInfixOperator.REMAINDER_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.RIGHT_SHIFT_SIGNED, PTInfixOperator.RIGHT_SHIFT_SIGNED_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED, PTInfixOperator.RIGHT_SHIFT_UNSIGNED_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.TIMES, PTInfixOperator.TIMES_LITERAL);
            infixOperToParseOper.put(InfixExpression.Operator.XOR, PTInfixOperator.XOR_LITERAL);
        }
        return (PTInfixOperator)infixOperToParseOper.get(operator);
    }

    public boolean visit(InfixExpression node) {
        PTInfixExpression inf = InstantiationFactory.eINSTANCE.createPTInfixExpression();
        inf.setLeftOperand(this.perform(node.getLeftOperand()));
        PTInfixOperator inoper = this.getParseInfix(node.getOperator());
        if (inoper == null) {
            throw new InvalidExpressionException(MessageFormat.format(WorkbenchUtilityMessages.ParseTreeCreationFromAST_OperatorTooComplicatedToHandle_EXC_, node.getOperator().toString()));
        }
        inf.setOperator(inoper);
        inf.setRightOperand(this.perform(node.getRightOperand()));
        EList eops = inf.getExtendedOperands();
        List neops = node.extendedOperands();
        int nsize = neops.size();
        int i = 0;
        while (i < nsize) {
            eops.add(this.perform((Expression)neops.get(i)));
            ++i;
        }
        this.expression = inf;
        return false;
    }

    public boolean visit(InstanceofExpression node) {
        PTInstanceof inof = InstantiationFactory.eINSTANCE.createPTInstanceof();
        inof.setOperand(this.perform(node.getLeftOperand()));
        inof.setType(this.resolver.resolveType(node.getRightOperand()));
        this.expression = inof;
        return false;
    }

    public boolean visit(PostfixExpression node) {
        return false;
    }

    public boolean visit(MethodInvocation node) {
        this.expression = this.createMethodInvocation(node.getName().getIdentifier(), this.perform(node.getExpression()), node.arguments());
        return false;
    }

    protected PTMethodInvocation createMethodInvocation(String name, PTExpression receiver, List argExpressions) {
        PTMethodInvocation mi = InstantiationFactory.eINSTANCE.createPTMethodInvocation();
        mi.setReceiver(receiver);
        mi.setName(name);
        EList args = mi.getArguments();
        int nsize = argExpressions.size();
        int i = 0;
        while (i < nsize) {
            args.add(this.perform((Expression)argExpressions.get(i)));
            ++i;
        }
        return mi;
    }

    public boolean visit(NullLiteral node) {
        this.expression = InstantiationFactory.eINSTANCE.createPTNullLiteral();
        return false;
    }

    public boolean visit(NumberLiteral node) {
        PTNumberLiteral nl = InstantiationFactory.eINSTANCE.createPTNumberLiteral();
        nl.setToken(node.getToken());
        this.expression = nl;
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        PTParenthesizedExpression pe = InstantiationFactory.eINSTANCE.createPTParenthesizedExpression();
        pe.setExpression(this.perform(node.getExpression()));
        this.expression = pe;
        return false;
    }

    private final PTPrefixOperator getParsePrefix(PrefixExpression.Operator operator) {
        if (prefixOperToParseOper == null) {
            prefixOperToParseOper = new HashMap(5);
            prefixOperToParseOper.put(PrefixExpression.Operator.COMPLEMENT, PTPrefixOperator.COMPLEMENT_LITERAL);
            prefixOperToParseOper.put(PrefixExpression.Operator.MINUS, PTPrefixOperator.MINUS_LITERAL);
            prefixOperToParseOper.put(PrefixExpression.Operator.NOT, PTPrefixOperator.NOT_LITERAL);
            prefixOperToParseOper.put(PrefixExpression.Operator.PLUS, PTPrefixOperator.PLUS_LITERAL);
        }
        return (PTPrefixOperator)prefixOperToParseOper.get(operator);
    }

    public boolean visit(PrefixExpression node) {
        PrefixExpression.Operator operator;
        if (node.getOperand().getNodeType() == 34 && ((operator = node.getOperator()) == PrefixExpression.Operator.PLUS || operator == PrefixExpression.Operator.MINUS)) {
            PTNumberLiteral nm = InstantiationFactory.eINSTANCE.createPTNumberLiteral();
            nm.setToken(String.valueOf(operator.toString()) + ((NumberLiteral)node.getOperand()).getToken());
            this.expression = nm;
            return false;
        }
        PTPrefixExpression pe = InstantiationFactory.eINSTANCE.createPTPrefixExpression();
        PTPrefixOperator ptoper = this.getParsePrefix(node.getOperator());
        if (ptoper == null) {
            throw new InvalidExpressionException(MessageFormat.format(WorkbenchUtilityMessages.ParseTreeCreationFromAST_OperatorTooComplicatedToHandle_EXC_, node.getOperator().toString()));
        }
        pe.setOperator(ptoper);
        pe.setExpression(this.perform(node.getOperand()));
        this.expression = pe;
        return false;
    }

    public boolean visit(QualifiedName node) {
        this.expression = this.resolver.resolveName((Name)node);
        return false;
    }

    public boolean visit(SimpleName node) {
        this.expression = this.resolver.resolveName((Name)node);
        return false;
    }

    public boolean visit(StringLiteral node) {
        PTStringLiteral sl = InstantiationFactory.eINSTANCE.createPTStringLiteral();
        sl.setEscapedValue(node.getEscapedValue());
        sl.setLiteralValue(node.getLiteralValue());
        this.expression = sl;
        return false;
    }

    public boolean visit(SuperFieldAccess node) {
        this.expression = this.createFieldAccess(node.getName().getIdentifier(), this.resolver.resolveThis());
        return false;
    }

    public boolean visit(SuperMethodInvocation node) {
        this.expression = this.createMethodInvocation(node.getName().getIdentifier(), this.resolver.resolveThis(), node.arguments());
        return false;
    }

    public boolean visit(ThisExpression node) {
        this.expression = this.resolver.resolveThis();
        return false;
    }

    public boolean visit(TypeLiteral node) {
        PTTypeLiteral ptl = InstantiationFactory.eINSTANCE.createPTTypeLiteral();
        ptl.setType(this.resolver.resolveType(node.getType()));
        this.expression = ptl;
        return false;
    }

    public static abstract class Resolver {
        public abstract PTExpression resolveName(Name var1) throws InvalidExpressionException;

        public abstract String resolveType(Type var1) throws InvalidExpressionException;

        public abstract PTExpression resolveThis() throws InvalidExpressionException;

        public abstract String resolveType(Name var1) throws InvalidExpressionException;

        protected final void throwInvalidExpressionException(String msg) throws InvalidExpressionException {
            throw new InvalidExpressionException(msg);
        }
    }

    protected static class InvalidExpressionException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 2429845631915206678L;

        public InvalidExpressionException(String s) {
            super(s);
        }
    }
}

