/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.single;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.DOMRangeHelper;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public abstract class SingleNodeCommand
extends DesignerCommand {
    List _structuredSelectedNodes = null;
    DOMRange _rangeSelection = null;
    IDOMElement _originalElement;
    IDOMElement _replacement;

    public SingleNodeCommand(String label, IDOMElement node) {
        super(label, (IDOMNode)node);
        this._originalElement = node;
    }

    protected void preExecute() {
        super.preExecute();
        ISelection selection = this.getViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            Object[] array = ((IStructuredSelection)selection).toArray();
            this._structuredSelectedNodes = new ArrayList();
            if (array != null) {
                int i = 0;
                while (i < array.length) {
                    EditPart part = (EditPart)array[i];
                    this._structuredSelectedNodes.add(part.getModel());
                    ++i;
                }
            }
        } else if (selection instanceof DesignRange) {
            DesignRange range = (DesignRange)selection;
            this._rangeSelection = DOMRangeHelper.toDOMRange(range);
        }
    }

    protected void setReplacedElement(IDOMElement ele) {
        this._replacement = ele;
    }

    protected IDOMElement getReplacedElment() {
        return this._replacement;
    }

    protected IDOMElement getOriginalElement() {
        return this._originalElement;
    }

    protected final ISelection getAfterCommandDesignerSelection() {
        if (this._structuredSelectedNodes != null) {
            int index;
            if (this._replacement != null && this._replacement != this._originalElement && (index = this._structuredSelectedNodes.indexOf(this._originalElement)) >= 0) {
                this._structuredSelectedNodes.set(index, this._replacement);
            }
            ArrayList<EditPart> parts = new ArrayList<EditPart>();
            int i = 0;
            int size = this._structuredSelectedNodes.size();
            while (i < size) {
                EditPart part;
                Object obj = this._structuredSelectedNodes.get(i);
                if (obj instanceof INodeNotifier && (part = (EditPart)((INodeNotifier)obj).getAdapterFor(EditPart.class)) != null) {
                    parts.add(part);
                }
                ++i;
            }
            StructuredSelection sel = new StructuredSelection(parts);
            return sel;
        }
        if (this._rangeSelection != null) {
            DOMRange newrange = this.handleReplacement(this._rangeSelection, this._originalElement, this._replacement);
            return DOMRangeHelper.toDesignRange(newrange);
        }
        return null;
    }

    private DOMRange handleReplacement(DOMRange selection, IDOMElement original, IDOMElement replacement) {
        if (replacement == null || replacement == original) {
            return selection;
        }
        return DOMRangeHelper.handleReplacement(selection, (Node)original, (Node)replacement);
    }
}

